# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...ai_agent.types.ai_agent import AiAgent
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.conversation_contacts import ConversationContacts
from ...types.conversation_first_contact_reply import ConversationFirstContactReply
from ...types.conversation_parts import ConversationParts
from ...types.conversation_rating import ConversationRating
from ...types.conversation_source import ConversationSource
from ...types.conversation_statistics import ConversationStatistics
from ...types.conversation_teammates import ConversationTeammates
from ...types.custom_attributes import CustomAttributes
from ...types.linked_object_list import LinkedObjectList
from ...types.sla_applied import SlaApplied
from ...types.tags import Tags
from .conversation_priority import ConversationPriority
from .conversation_state import ConversationState


class Conversation(UncheckedBaseModel):
    """
    Conversations are how you can communicate with users in Intercom. They are created when a contact replies to an outbound message, or when one admin directly sends a message to a single contact.
    """

    type: typing.Optional[typing.Literal["conversation"]] = pydantic.Field(default=None)
    """
    Always conversation.
    """

    id: str = pydantic.Field()
    """
    The id representing the conversation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title given to the conversation.
    """

    created_at: int = pydantic.Field()
    """
    The time the conversation was created.
    """

    updated_at: int = pydantic.Field()
    """
    The last time the conversation was updated.
    """

    waiting_since: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time a Contact responded to an Admin. In other words, the time a customer started waiting for a response. Set to null if last reply is from an Admin.
    """

    snoozed_until: typing.Optional[int] = pydantic.Field(default=None)
    """
    If set this is the time in the future when this conversation will be marked as open. i.e. it will be in a snoozed state until this time. i.e. it will be in a snoozed state until this time.
    """

    open: bool = pydantic.Field()
    """
    Indicates whether a conversation is open (true) or closed (false).
    """

    state: ConversationState = pydantic.Field()
    """
    Can be set to "open", "closed" or "snoozed".
    """

    read: bool = pydantic.Field()
    """
    Indicates whether a conversation has been read.
    """

    priority: typing.Optional[ConversationPriority] = pydantic.Field(default=None)
    """
    If marked as priority, it will return priority or else not_priority.
    """

    admin_assignee_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of the admin assigned to the conversation. If it's not assigned to an admin it will return null.
    """

    team_assignee_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the team assigned to the conversation. If it's not assigned to a team it will return null.
    """

    tags: typing.Optional[Tags] = None
    conversation_rating: typing.Optional[ConversationRating] = None
    source: ConversationSource
    contacts: ConversationContacts
    teammates: ConversationTeammates
    custom_attributes: CustomAttributes
    first_contact_reply: typing.Optional[ConversationFirstContactReply] = None
    sla_applied: typing.Optional[SlaApplied] = None
    statistics: typing.Optional[ConversationStatistics] = None
    conversation_parts: typing.Optional[ConversationParts] = None
    linked_objects: typing.Optional[LinkedObjectList] = None
    ai_agent_participated: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicates whether the AI Agent participated in the conversation.
    """

    ai_agent: typing.Optional[AiAgent] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
