# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .data_attribute_data_type import DataAttributeDataType
from .data_attribute_model import DataAttributeModel


class DataAttribute(UncheckedBaseModel):
    """
    Data Attributes are metadata used to describe your contact, company and conversation models. These include standard and custom attributes. By using the data attributes endpoint, you can get the global list of attributes for your workspace, as well as create and archive custom attributes.
    """

    type: typing.Literal["data_attribute"] = pydantic.Field(default="data_attribute")
    """
    Value is `data_attribute`.
    """

    id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The unique identifier for the data attribute which is given by Intercom. Only available for custom attributes.
    """

    model: typing.Optional[DataAttributeModel] = pydantic.Field(default=None)
    """
    Value is `contact` for user/lead attributes and `company` for company attributes.
    """

    name: str = pydantic.Field()
    """
    Name of the attribute.
    """

    full_name: str = pydantic.Field()
    """
    Full name of the attribute. Should match the name unless it's a nested attribute. We can split full_name on `.` to access nested user object values.
    """

    label: str = pydantic.Field()
    """
    Readable name of the attribute (i.e. name you see in the UI)
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Readable description of the attribute.
    """

    data_type: DataAttributeDataType = pydantic.Field()
    """
    The data type of the attribute.
    """

    options: typing.Optional[typing.List[str]] = pydantic.Field(default=None)
    """
    List of predefined options for attribute value.
    """

    api_writable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Can this attribute be updated through API
    """

    messenger_writable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Can this attribute be updated by the Messenger
    """

    ui_writable: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Can this attribute be updated in the UI
    """

    custom: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Set to true if this is a CDA
    """

    archived: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Is this attribute archived. (Only applicable to CDAs)
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the attribute was created as a UTC Unix timestamp
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the attribute was last updated as a UTC Unix timestamp
    """

    admin_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Teammate who created the attribute. Only applicable to CDAs
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
