# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class CreateDataEventSummariesRequestEventSummaries(UncheckedBaseModel):
    """
    A list of event summaries for the user. Each event summary should contain the event name, the time the event occurred, and the number of times the event occurred. The event name should be a past tense 'verb-noun' combination, to improve readability, for example `updated-plan`.
    """

    event_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the event that occurred. A good event name is typically a past tense 'verb-noun' combination, to improve readability, for example `updated-plan`.
    """

    count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of times the event occurred.
    """

    first: typing.Optional[int] = pydantic.Field(default=None)
    """
    The first time the event was sent
    """

    last: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the event was sent
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
