# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.pagination import AsyncPager, SyncPager
from ...core.request_options import RequestOptions
from ...help_center.types.collection import Collection
from ...types.deleted_collection_object import DeletedCollectionObject
from ...types.group_translated_content import GroupTranslatedContent
from .raw_client import AsyncRawCollectionsClient, RawCollectionsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CollectionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCollectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCollectionsClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Collection]:
        """
        You can fetch a list of all collections by making a GET request to `https://api.intercom.io/help_center/collections`.

        Collections will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Collection]
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        response = client.help_centers.collections.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(page=page, per_page=per_page, request_options=request_options)

    def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[GroupTranslatedContent] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        help_center_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        You can create a new collection by making a POST request to `https://api.intercom.io/help_center/collections.`

        Parameters
        ----------
        name : str
            The name of the collection. For multilingual collections, this will be the name of the default language's content.

        description : typing.Optional[str]
            The description of the collection. For multilingual collections, this will be the description of the default language's content.

        translated_content : typing.Optional[GroupTranslatedContent]

        parent_id : typing.Optional[str]
            The id of the parent collection. If `null` then it will be created as the first level collection.

        help_center_id : typing.Optional[int]
            The id of the help center where the collection will be created. If `null` then it will be created in the default help center.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            collection created

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.help_centers.collections.create(
            name="Thanks for everything",
        )
        """
        _response = self._raw_client.create(
            name=name,
            description=description,
            translated_content=translated_content,
            parent_id=parent_id,
            help_center_id=help_center_id,
            request_options=request_options,
        )
        return _response.data

    def find(self, collection_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        You can fetch the details of a single collection by making a GET request to `https://api.intercom.io/help_center/collections/<id>`.

        Parameters
        ----------
        collection_id : str
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Collection found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.help_centers.collections.find(
            collection_id="123",
        )
        """
        _response = self._raw_client.find(collection_id, request_options=request_options)
        return _response.data

    def update(
        self,
        collection_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[GroupTranslatedContent] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        You can update the details of a single collection by making a PUT request to `https://api.intercom.io/collections/<id>`.

        Parameters
        ----------
        collection_id : str
            The unique identifier for the collection which is given by Intercom.

        name : typing.Optional[str]
            The name of the collection. For multilingual collections, this will be the name of the default language's content.

        description : typing.Optional[str]
            The description of the collection. For multilingual collections, this will be the description of the default language's content.

        translated_content : typing.Optional[GroupTranslatedContent]

        parent_id : typing.Optional[str]
            The id of the parent collection. If `null` then it will be updated as the first level collection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.help_centers.collections.update(
            collection_id="123",
            name="Update collection name",
        )
        """
        _response = self._raw_client.update(
            collection_id,
            name=name,
            description=description,
            translated_content=translated_content,
            parent_id=parent_id,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self, collection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedCollectionObject:
        """
        You can delete a single collection by making a DELETE request to `https://api.intercom.io/collections/<id>`.

        Parameters
        ----------
        collection_id : str
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedCollectionObject
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.help_centers.collections.delete(
            collection_id="123",
        )
        """
        _response = self._raw_client.delete(collection_id, request_options=request_options)
        return _response.data


class AsyncCollectionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCollectionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCollectionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCollectionsClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Collection]:
        """
        You can fetch a list of all collections by making a GET request to `https://api.intercom.io/help_center/collections`.

        Collections will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated collections first.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Collection]
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.help_centers.collections.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(page=page, per_page=per_page, request_options=request_options)

    async def create(
        self,
        *,
        name: str,
        description: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[GroupTranslatedContent] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        help_center_id: typing.Optional[int] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        You can create a new collection by making a POST request to `https://api.intercom.io/help_center/collections.`

        Parameters
        ----------
        name : str
            The name of the collection. For multilingual collections, this will be the name of the default language's content.

        description : typing.Optional[str]
            The description of the collection. For multilingual collections, this will be the description of the default language's content.

        translated_content : typing.Optional[GroupTranslatedContent]

        parent_id : typing.Optional[str]
            The id of the parent collection. If `null` then it will be created as the first level collection.

        help_center_id : typing.Optional[int]
            The id of the help center where the collection will be created. If `null` then it will be created in the default help center.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            collection created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.help_centers.collections.create(
                name="Thanks for everything",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            name=name,
            description=description,
            translated_content=translated_content,
            parent_id=parent_id,
            help_center_id=help_center_id,
            request_options=request_options,
        )
        return _response.data

    async def find(self, collection_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Collection:
        """
        You can fetch the details of a single collection by making a GET request to `https://api.intercom.io/help_center/collections/<id>`.

        Parameters
        ----------
        collection_id : str
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            Collection found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.help_centers.collections.find(
                collection_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(collection_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        collection_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[GroupTranslatedContent] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Collection:
        """
        You can update the details of a single collection by making a PUT request to `https://api.intercom.io/collections/<id>`.

        Parameters
        ----------
        collection_id : str
            The unique identifier for the collection which is given by Intercom.

        name : typing.Optional[str]
            The name of the collection. For multilingual collections, this will be the name of the default language's content.

        description : typing.Optional[str]
            The description of the collection. For multilingual collections, this will be the description of the default language's content.

        translated_content : typing.Optional[GroupTranslatedContent]

        parent_id : typing.Optional[str]
            The id of the parent collection. If `null` then it will be updated as the first level collection.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Collection
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.help_centers.collections.update(
                collection_id="123",
                name="Update collection name",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            collection_id,
            name=name,
            description=description,
            translated_content=translated_content,
            parent_id=parent_id,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, collection_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedCollectionObject:
        """
        You can delete a single collection by making a DELETE request to `https://api.intercom.io/collections/<id>`.

        Parameters
        ----------
        collection_id : str
            The unique identifier for the collection which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedCollectionObject
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.help_centers.collections.delete(
                collection_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(collection_id, request_options=request_options)
        return _response.data
