# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.create_ticket_request_contacts_item import CreateTicketRequestContactsItem
from ..types.search_request_query import SearchRequestQuery
from ..types.starting_after_paging import StartingAfterPaging
from ..types.ticket_reply import TicketReply
from ..types.ticket_request_custom_attributes import TicketRequestCustomAttributes
from .raw_client import AsyncRawTicketsClient, RawTicketsClient
from .types.ticket import Ticket
from .types.tickets_reply_request_body import TicketsReplyRequestBody
from .types.update_ticket_request_assignment import UpdateTicketRequestAssignment
from .types.update_ticket_request_state import UpdateTicketRequestState

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TicketsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTicketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTicketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTicketsClient
        """
        return self._raw_client

    def reply(
        self,
        ticket_id: str,
        *,
        request: TicketsReplyRequestBody,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketReply:
        """
        You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.

        Parameters
        ----------
        ticket_id : str

        request : TicketsReplyRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketReply
            Admin quick_reply reply

        Examples
        --------
        from intercom import ContactReplyTicketIntercomUserIdRequest, Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.tickets.reply(
            ticket_id="123",
            request=ContactReplyTicketIntercomUserIdRequest(
                body="Thanks again :)",
                intercom_user_id="667d619d8a68186f43bafe82",
            ),
        )
        """
        _response = self._raw_client.reply(ticket_id, request=request, request_options=request_options)
        return _response.data

    def create(
        self,
        *,
        ticket_type_id: str,
        contacts: typing.Sequence[CreateTicketRequestContactsItem],
        company_id: typing.Optional[str] = OMIT,
        created_at: typing.Optional[int] = OMIT,
        ticket_attributes: typing.Optional[TicketRequestCustomAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Ticket:
        """
        You can create a new ticket.

        Parameters
        ----------
        ticket_type_id : str
            The ID of the type of ticket you want to create

        contacts : typing.Sequence[CreateTicketRequestContactsItem]
            The list of contacts (users or leads) affected by this ticket. Currently only one is allowed

        company_id : typing.Optional[str]
            The ID of the company that the ticket is associated with. The ID that you set upon company creation.

        created_at : typing.Optional[int]
            The time the ticket was created. If not provided, the current time will be used.

        ticket_attributes : typing.Optional[TicketRequestCustomAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket
            Successful response

        Examples
        --------
        from intercom import CreateTicketRequestContactsItemId, Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.tickets.create(
            ticket_type_id="1234",
            contacts=[
                CreateTicketRequestContactsItemId(
                    id="667d61b78a68186f43bafe8d",
                )
            ],
            ticket_attributes={
                "_default_title_": "example",
                "_default_description_": "there is a problem",
            },
        )
        """
        _response = self._raw_client.create(
            ticket_type_id=ticket_type_id,
            contacts=contacts,
            company_id=company_id,
            created_at=created_at,
            ticket_attributes=ticket_attributes,
            request_options=request_options,
        )
        return _response.data

    def get(self, ticket_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Ticket:
        """
        You can fetch the details of a single ticket.

        Parameters
        ----------
        ticket_id : str
            The unique identifier for the ticket which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket
            Ticket found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.tickets.get(
            ticket_id="ticket_id",
        )
        """
        _response = self._raw_client.get(ticket_id, request_options=request_options)
        return _response.data

    def update(
        self,
        ticket_id: str,
        *,
        ticket_attributes: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        state: typing.Optional[UpdateTicketRequestState] = OMIT,
        open: typing.Optional[bool] = OMIT,
        is_shared: typing.Optional[bool] = OMIT,
        snoozed_until: typing.Optional[int] = OMIT,
        assignment: typing.Optional[UpdateTicketRequestAssignment] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Ticket:
        """
        You can update a ticket.

        Parameters
        ----------
        ticket_id : str
            The unique identifier for the ticket which is given by Intercom

        ticket_attributes : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The attributes set on the ticket.

        state : typing.Optional[UpdateTicketRequestState]
            The state of the ticket.

        open : typing.Optional[bool]
            Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.

        is_shared : typing.Optional[bool]
            Specify whether the ticket is visible to users.

        snoozed_until : typing.Optional[int]
            The time you want the ticket to reopen.

        assignment : typing.Optional[UpdateTicketRequestAssignment]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket
            Successful response

        Examples
        --------
        from intercom import Intercom
        from intercom.tickets import UpdateTicketRequestAssignment

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.tickets.update(
            ticket_id="ticket_id",
            ticket_attributes={
                "_default_title_": "example",
                "_default_description_": "there is a problem",
            },
            state="in_progress",
            open=True,
            snoozed_until=1673609604,
            assignment=UpdateTicketRequestAssignment(
                admin_id="991267883",
                assignee_id="991267885",
            ),
        )
        """
        _response = self._raw_client.update(
            ticket_id,
            ticket_attributes=ticket_attributes,
            state=state,
            open=open,
            is_shared=is_shared,
            snoozed_until=snoozed_until,
            assignment=assignment,
            request_options=request_options,
        )
        return _response.data

    def search(
        self,
        *,
        query: SearchRequestQuery,
        pagination: typing.Optional[StartingAfterPaging] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[Ticket]:
        """
        You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.

        To search for tickets, you send a `POST` request to `https://api.intercom.io/tickets/search`.

        This will accept a query object in the body which will define your filters.
        {% admonition type="warning" name="Optimizing search queries" %}
          Search queries can be complex, so optimizing them can help the performance of your search.
          Use the `AND` and `OR` operators to combine multiple filters to get the exact results you need and utilize
          pagination to limit the number of results returned. The default is `20` results per page.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request) for more details on how to use the `starting_after` param.
        {% /admonition %}

        ### Nesting & Limitations

        You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
        There are some limitations to the amount of multiples there can be:
        - There's a limit of max 2 nested filters
        - There's a limit of max 15 filters for each AND or OR group

        ### Accepted Fields

        Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as `created_at` accepts a date, the `value` cannot be a string such as `"foobar"`).

        | Field                                     | Type                                                                                     |
        | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
        | id                                        | String                                                                                   |
        | created_at                                | Date (UNIX timestamp)                                                                    |
        | updated_at                                | Date (UNIX timestamp)                                                                    |
        | _default_title_                           | String                                                                                   |
        | _default_description_                     | String                                                                                   |
        | category                                  | String                                                                                   |
        | ticket_type_id                            | String                                                                                   |
        | contact_ids                               | String                                                                                   |
        | teammate_ids                              | String                                                                                   |
        | admin_assignee_id                         | String                                                                                   |
        | team_assignee_id                          | String                                                                                   |
        | open                                      | Boolean                                                                                  |
        | state                                     | String                                                                                   |
        | snoozed_until                             | Date (UNIX timestamp)                                                                    |
        | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |

        ### Accepted Operators

        {% admonition type="info" name="Searching based on `created_at`" %}
          You may use the `<=` or `>=` operators to search by `created_at`.
        {% /admonition %}

        The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (`"="`). The operator has to be compatible with the field's type  (eg. you cannot search with `>` for a given string value as it's only compatible for integer's and dates).

        | Operator | Valid Types                    | Description                                                  |
        | :------- | :----------------------------- | :----------------------------------------------------------- |
        | =        | All                            | Equals                                                       |
        | !=       | All                            | Doesn't Equal                                                |
        | IN       | All                            | In  Shortcut for `OR` queries  Values most be in Array       |
        | NIN      | All                            | Not In  Shortcut for `OR !` queries  Values must be in Array |
        | >        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
        | <       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
        | ~        | String                         | Contains                                                     |
        | !~       | String                         | Doesn't Contain                                              |
        | ^        | String                         | Starts With                                                  |
        | $        | String                         | Ends With                                                    |

        Parameters
        ----------
        query : SearchRequestQuery

        pagination : typing.Optional[StartingAfterPaging]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[Ticket]
            successful

        Examples
        --------
        from intercom import (
            Intercom,
            MultipleFilterSearchRequest,
            SingleFilterSearchRequest,
            StartingAfterPaging,
        )

        client = Intercom(
            token="YOUR_TOKEN",
        )
        response = client.tickets.search(
            query=MultipleFilterSearchRequest(
                operator="AND",
                value=[
                    SingleFilterSearchRequest(
                        field="created_at",
                        operator=">",
                        value="1306054154",
                    )
                ],
            ),
            pagination=StartingAfterPaging(
                per_page=5,
            ),
        )
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.search(query=query, pagination=pagination, request_options=request_options)


class AsyncTicketsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTicketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTicketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTicketsClient
        """
        return self._raw_client

    async def reply(
        self,
        ticket_id: str,
        *,
        request: TicketsReplyRequestBody,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketReply:
        """
        You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.

        Parameters
        ----------
        ticket_id : str

        request : TicketsReplyRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketReply
            Admin quick_reply reply

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom, ContactReplyTicketIntercomUserIdRequest

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tickets.reply(
                ticket_id="123",
                request=ContactReplyTicketIntercomUserIdRequest(
                    body="Thanks again :)",
                    intercom_user_id="667d619d8a68186f43bafe82",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.reply(ticket_id, request=request, request_options=request_options)
        return _response.data

    async def create(
        self,
        *,
        ticket_type_id: str,
        contacts: typing.Sequence[CreateTicketRequestContactsItem],
        company_id: typing.Optional[str] = OMIT,
        created_at: typing.Optional[int] = OMIT,
        ticket_attributes: typing.Optional[TicketRequestCustomAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Ticket:
        """
        You can create a new ticket.

        Parameters
        ----------
        ticket_type_id : str
            The ID of the type of ticket you want to create

        contacts : typing.Sequence[CreateTicketRequestContactsItem]
            The list of contacts (users or leads) affected by this ticket. Currently only one is allowed

        company_id : typing.Optional[str]
            The ID of the company that the ticket is associated with. The ID that you set upon company creation.

        created_at : typing.Optional[int]
            The time the ticket was created. If not provided, the current time will be used.

        ticket_attributes : typing.Optional[TicketRequestCustomAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom, CreateTicketRequestContactsItemId

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tickets.create(
                ticket_type_id="1234",
                contacts=[
                    CreateTicketRequestContactsItemId(
                        id="667d61b78a68186f43bafe8d",
                    )
                ],
                ticket_attributes={
                    "_default_title_": "example",
                    "_default_description_": "there is a problem",
                },
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            ticket_type_id=ticket_type_id,
            contacts=contacts,
            company_id=company_id,
            created_at=created_at,
            ticket_attributes=ticket_attributes,
            request_options=request_options,
        )
        return _response.data

    async def get(self, ticket_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Ticket:
        """
        You can fetch the details of a single ticket.

        Parameters
        ----------
        ticket_id : str
            The unique identifier for the ticket which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket
            Ticket found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tickets.get(
                ticket_id="ticket_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get(ticket_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        ticket_id: str,
        *,
        ticket_attributes: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        state: typing.Optional[UpdateTicketRequestState] = OMIT,
        open: typing.Optional[bool] = OMIT,
        is_shared: typing.Optional[bool] = OMIT,
        snoozed_until: typing.Optional[int] = OMIT,
        assignment: typing.Optional[UpdateTicketRequestAssignment] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Ticket:
        """
        You can update a ticket.

        Parameters
        ----------
        ticket_id : str
            The unique identifier for the ticket which is given by Intercom

        ticket_attributes : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The attributes set on the ticket.

        state : typing.Optional[UpdateTicketRequestState]
            The state of the ticket.

        open : typing.Optional[bool]
            Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.

        is_shared : typing.Optional[bool]
            Specify whether the ticket is visible to users.

        snoozed_until : typing.Optional[int]
            The time you want the ticket to reopen.

        assignment : typing.Optional[UpdateTicketRequestAssignment]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Ticket
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.tickets import UpdateTicketRequestAssignment

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.tickets.update(
                ticket_id="ticket_id",
                ticket_attributes={
                    "_default_title_": "example",
                    "_default_description_": "there is a problem",
                },
                state="in_progress",
                open=True,
                snoozed_until=1673609604,
                assignment=UpdateTicketRequestAssignment(
                    admin_id="991267883",
                    assignee_id="991267885",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            ticket_id,
            ticket_attributes=ticket_attributes,
            state=state,
            open=open,
            is_shared=is_shared,
            snoozed_until=snoozed_until,
            assignment=assignment,
            request_options=request_options,
        )
        return _response.data

    async def search(
        self,
        *,
        query: SearchRequestQuery,
        pagination: typing.Optional[StartingAfterPaging] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[Ticket]:
        """
        You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.

        To search for tickets, you send a `POST` request to `https://api.intercom.io/tickets/search`.

        This will accept a query object in the body which will define your filters.
        {% admonition type="warning" name="Optimizing search queries" %}
          Search queries can be complex, so optimizing them can help the performance of your search.
          Use the `AND` and `OR` operators to combine multiple filters to get the exact results you need and utilize
          pagination to limit the number of results returned. The default is `20` results per page.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request) for more details on how to use the `starting_after` param.
        {% /admonition %}

        ### Nesting & Limitations

        You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
        There are some limitations to the amount of multiples there can be:
        - There's a limit of max 2 nested filters
        - There's a limit of max 15 filters for each AND or OR group

        ### Accepted Fields

        Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as `created_at` accepts a date, the `value` cannot be a string such as `"foobar"`).

        | Field                                     | Type                                                                                     |
        | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
        | id                                        | String                                                                                   |
        | created_at                                | Date (UNIX timestamp)                                                                    |
        | updated_at                                | Date (UNIX timestamp)                                                                    |
        | _default_title_                           | String                                                                                   |
        | _default_description_                     | String                                                                                   |
        | category                                  | String                                                                                   |
        | ticket_type_id                            | String                                                                                   |
        | contact_ids                               | String                                                                                   |
        | teammate_ids                              | String                                                                                   |
        | admin_assignee_id                         | String                                                                                   |
        | team_assignee_id                          | String                                                                                   |
        | open                                      | Boolean                                                                                  |
        | state                                     | String                                                                                   |
        | snoozed_until                             | Date (UNIX timestamp)                                                                    |
        | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |

        ### Accepted Operators

        {% admonition type="info" name="Searching based on `created_at`" %}
          You may use the `<=` or `>=` operators to search by `created_at`.
        {% /admonition %}

        The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (`"="`). The operator has to be compatible with the field's type  (eg. you cannot search with `>` for a given string value as it's only compatible for integer's and dates).

        | Operator | Valid Types                    | Description                                                  |
        | :------- | :----------------------------- | :----------------------------------------------------------- |
        | =        | All                            | Equals                                                       |
        | !=       | All                            | Doesn't Equal                                                |
        | IN       | All                            | In  Shortcut for `OR` queries  Values most be in Array       |
        | NIN      | All                            | Not In  Shortcut for `OR !` queries  Values must be in Array |
        | >        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
        | <       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
        | ~        | String                         | Contains                                                     |
        | !~       | String                         | Doesn't Contain                                              |
        | ^        | String                         | Starts With                                                  |
        | $        | String                         | Ends With                                                    |

        Parameters
        ----------
        query : SearchRequestQuery

        pagination : typing.Optional[StartingAfterPaging]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[Ticket]
            successful

        Examples
        --------
        import asyncio

        from intercom import (
            AsyncIntercom,
            MultipleFilterSearchRequest,
            SingleFilterSearchRequest,
            StartingAfterPaging,
        )

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.tickets.search(
                query=MultipleFilterSearchRequest(
                    operator="AND",
                    value=[
                        SingleFilterSearchRequest(
                            field="created_at",
                            operator=">",
                            value="1306054154",
                        )
                    ],
                ),
                pagination=StartingAfterPaging(
                    per_page=5,
                ),
            )
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.search(query=query, pagination=pagination, request_options=request_options)
