# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .article_content_state import ArticleContentState


class ArticleContent(UncheckedBaseModel):
    """
    The Content of an Article.
    """

    type: typing.Literal["article_content"] = pydantic.Field(default="article_content")
    """
    The type of object - `article_content` .
    """

    title: str = pydantic.Field()
    """
    The title of the article.
    """

    description: str = pydantic.Field()
    """
    The description of the article.
    """

    body: str = pydantic.Field()
    """
    The body of the article.
    """

    author_id: int = pydantic.Field()
    """
    The ID of the author of the article.
    """

    state: ArticleContentState = pydantic.Field()
    """
    Whether the article is `published` or is a `draft` .
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the article was created (seconds).
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the article was last updated (seconds).
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL of the article.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
