# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel, UnionMetadata
from .action_component import ActionComponent
from .button_component_style import ButtonComponentStyle
from .checkbox_component_save_state import CheckboxComponentSaveState
from .checkbox_option import CheckboxOption
from .data_table_item import DataTableItem
from .dropdown_component_save_state import DropdownComponentSaveState
from .dropdown_option import DropdownOption
from .image_component_align import ImageComponentAlign
from .input_component_save_state import InputComponentSaveState
from .list_component_items_item import ListComponentItemsItem
from .single_select_component_save_state import SingleSelectComponentSaveState
from .single_select_option import SingleSelectOption
from .spacer_component_size import SpacerComponentSize
from .text_component_align import TextComponentAlign
from .text_component_style import TextComponentStyle
from .url_action_component import UrlActionComponent


class Component_Button(UncheckedBaseModel):
    type: typing.Literal["button"] = "button"
    id: str
    label: str
    action: ActionComponent
    style: typing.Optional[ButtonComponentStyle] = None
    disabled: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_Checkbox(UncheckedBaseModel):
    type: typing.Literal["checkbox"] = "checkbox"
    id: str
    option: typing.List[CheckboxOption]
    label: str
    value: typing.Optional[typing.List[str]] = None
    save_state: typing.Optional[CheckboxComponentSaveState] = None
    disabled: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_Dropdown(UncheckedBaseModel):
    type: typing.Literal["dropdown"] = "dropdown"
    id: str
    options: typing.List[DropdownOption]
    label: typing.Optional[str] = None
    value: typing.Optional[str] = None
    save_state: typing.Optional[DropdownComponentSaveState] = None
    disabled: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_Input(UncheckedBaseModel):
    type: typing.Literal["input"] = "input"
    id: str
    label: typing.Optional[str] = None
    placeholder: typing.Optional[str] = None
    value: typing.Optional[str] = None
    action: typing.Optional[ActionComponent] = None
    save_state: typing.Optional[InputComponentSaveState] = None
    disabled: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_List(UncheckedBaseModel):
    type: typing.Literal["list"] = "list"
    items: typing.List[ListComponentItemsItem]
    disabled: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_SingleSelect(UncheckedBaseModel):
    type: typing.Literal["single-select"] = "single-select"
    id: str
    options: typing.List[SingleSelectOption]
    label: typing.Optional[str] = None
    value: typing.Optional[str] = None
    save_state: typing.Optional[SingleSelectComponentSaveState] = None
    disabled: typing.Optional[bool] = None
    action: typing.Optional[ActionComponent] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_Textarea(UncheckedBaseModel):
    type: typing.Literal["textarea"] = "textarea"
    id: str
    label: typing.Optional[str] = None
    placeholder: typing.Optional[str] = None
    value: typing.Optional[str] = None
    error: typing.Optional[bool] = None
    disabled: typing.Optional[bool] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_DataTable(UncheckedBaseModel):
    type: typing.Literal["data-table"] = "data-table"
    items: typing.List[DataTableItem]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_Divider(UncheckedBaseModel):
    type: typing.Literal["divider"] = "divider"
    id: typing.Optional[str] = None
    bottom_margin: typing.Optional[typing.Literal["none"]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_Image(UncheckedBaseModel):
    type: typing.Literal["image"] = "image"
    id: typing.Optional[str] = None
    url: str
    align: typing.Optional[ImageComponentAlign] = None
    width: int
    height: int
    rounded: typing.Optional[bool] = None
    bottom_margin: typing.Optional[typing.Literal["none"]] = None
    action: typing.Optional[UrlActionComponent] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_Spacer(UncheckedBaseModel):
    type: typing.Literal["spacer"] = "spacer"
    id: typing.Optional[str] = None
    size: typing.Optional[SpacerComponentSize] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


class Component_Text(UncheckedBaseModel):
    type: typing.Literal["text"] = "text"
    id: typing.Optional[str] = None
    text: str
    align: typing.Optional[TextComponentAlign] = None
    style: typing.Optional[TextComponentStyle] = None
    bottom_margin: typing.Optional[typing.Literal["none"]] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow


Component = typing_extensions.Annotated[
    typing.Union[
        Component_Button,
        Component_Checkbox,
        Component_Dropdown,
        Component_Input,
        Component_List,
        Component_SingleSelect,
        Component_Textarea,
        Component_DataTable,
        Component_Divider,
        Component_Image,
        Component_Spacer,
        Component_Text,
    ],
    UnionMetadata(discriminant="type"),
]
