# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ContactDeleted(UncheckedBaseModel):
    """
    deleted contact object
    """

    type: typing.Literal["contact"] = pydantic.Field(default="contact")
    """
    always contact
    """

    id: str = pydantic.Field()
    """
    The unique identifier for the contact which is given by Intercom.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the contact which is provided by the Client.
    """

    deleted: bool = pydantic.Field()
    """
    Whether the contact is deleted or not.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
