# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .context_location import ContextLocation


class Context(UncheckedBaseModel):
    """
    The context object provides additional details on where the app has been added (or is currently being used), what page the app is being used on, and information on the Messenger settings. This is in order for you give a fully customised experience based on the customers use case.

    If the `location` is `conversation` then you will also be given a `conversation_id`. If you need to use details about the conversation, then you have to use the `conversation_id` to [make a call to our Conversations API and retrieve the conversation object](https://developers.intercom.com/intercom-api-reference/reference#get-a-single-conversation).
    """

    conversation_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of the conversation where the app is added or being used.
    """

    location: typing.Optional[ContextLocation] = pydantic.Field(default=None)
    """
    Where the app is added or the action took place. Can be either 'conversation', 'home', 'message', or 'operator'.
    """

    locale: typing.Optional[str] = pydantic.Field(default=None)
    """
    The default end-user language of the Messenger. Use to localise Messenger App content.
    """

    messenger_action_colour: typing.Optional[str] = pydantic.Field(default=None)
    """
    The messengers action colour. Use in Sheets and Icons to make a Messenger App experience feel part of the host Messenger.
    """

    messenger_background_colour: typing.Optional[str] = pydantic.Field(default=None)
    """
    The messengers background colour. Use in Sheets and Icons to make a Messenger App experience feel part of the host Messenger.
    """

    referrer: typing.Optional[str] = pydantic.Field(default=None)
    """
    The current page URL where the app is being used.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
