# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .conversation_part_author import ConversationPartAuthor
from .part_attachment import PartAttachment
from .reference import Reference


class ConversationPart(UncheckedBaseModel):
    """
    A Conversation Part represents a message in the conversation.
    """

    type: typing.Literal["conversation_part"] = pydantic.Field(default="conversation_part")
    """
    Always conversation_part
    """

    id: str = pydantic.Field()
    """
    The id representing the conversation part.
    """

    part_type: str = pydantic.Field()
    """
    The type of conversation part.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.
    """

    created_at: int = pydantic.Field()
    """
    The time the conversation part was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the conversation part was updated.
    """

    notified_at: int = pydantic.Field()
    """
    The time the user was notified with the conversation part.
    """

    assigned_to: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The id of the admin that was assigned the conversation by this conversation_part (null if there has been no change in assignment.)
    """

    author: ConversationPartAuthor
    attachments: typing.Optional[typing.List[PartAttachment]] = pydantic.Field(default=None)
    """
    A list of attachments for the part.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external id of the conversation part
    """

    redacted: bool = pydantic.Field()
    """
    Whether or not the conversation part has been redacted.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
