# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ConversationPartAuthor(UncheckedBaseModel):
    """
    The object who initiated the conversation, which can be a Contact, Admin or Team. Bots and campaigns send messages on behalf of Admins or Teams. For Twitter, this will be blank.
    """

    type: str = pydantic.Field()
    """
    The type of the author
    """

    id: str = pydantic.Field()
    """
    The id of the author
    """

    name: str = pydantic.Field()
    """
    The name of the author
    """

    email: str = pydantic.Field()
    """
    The email of the author
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
