# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ConversationStatistics(UncheckedBaseModel):
    """
    A Statistics object containing all information required for reporting, with timestamps and calculated metrics.
    """

    type: typing.Literal["conversation_statistics"] = pydantic.Field(default="conversation_statistics")
    """
    
    """

    time_to_assignment: typing.Optional[int] = pydantic.Field(default=None)
    """
    Duration until last assignment before first admin reply. In seconds.
    """

    time_to_admin_reply: typing.Optional[int] = pydantic.Field(default=None)
    """
    Duration until first admin reply. Subtracts out of business hours. In seconds.
    """

    time_to_first_close: typing.Optional[int] = pydantic.Field(default=None)
    """
    Duration until conversation was closed first time. Subtracts out of business hours. In seconds.
    """

    time_to_last_close: typing.Optional[int] = pydantic.Field(default=None)
    """
    Duration until conversation was closed last time. Subtracts out of business hours. In seconds.
    """

    median_time_to_reply: typing.Optional[int] = pydantic.Field(default=None)
    """
    Median based on all admin replies after a contact reply. Subtracts out of business hours. In seconds.
    """

    first_contact_reply_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of first text conversation part from a contact.
    """

    first_assignment_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of first assignment after first_contact_reply_at.
    """

    first_admin_reply_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of first admin reply after first_contact_reply_at.
    """

    first_close_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of first close after first_contact_reply_at.
    """

    last_assignment_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of last assignment after first_contact_reply_at.
    """

    last_assignment_admin_reply_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of first admin reply since most recent assignment.
    """

    last_contact_reply_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of the last conversation part from a contact.
    """

    last_admin_reply_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of the last conversation part from an admin.
    """

    last_close_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    Time of the last conversation close.
    """

    last_closed_by_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The last admin who closed the conversation. Returns a reference to an Admin object.
    """

    count_reopens: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of reopens after first_contact_reply_at.
    """

    count_assignments: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of assignments after first_contact_reply_at.
    """

    count_conversation_parts: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of conversation parts.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
