# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .canvas_object import CanvasObject


class CurrentCanvas(UncheckedBaseModel):
    """
    The current canvas that was most recently showing before the request was sent. This object mirrors the same format as the Canvas Object.
    """

    current_canvas: CanvasObject = pydantic.Field()
    """
    The canvas object representing the current canvas state.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
