# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .dropdown_component_save_state import DropdownComponentSaveState
from .dropdown_option import DropdownOption


class DropdownComponent(UncheckedBaseModel):
    """
    A dropdown component is used to capture a choice from the options that you provide.

    When submitted, the dropdown choices are returned in a hash with the id from the dropdown component used as the key and the id from the chosen option as the value.
    """

    id: str = pydantic.Field()
    """
    A unique identifier for the component.
    """

    options: typing.List[DropdownOption] = pydantic.Field()
    """
    The list of options. Can provide 2 to 10.
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    The text shown above the dropdown.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The option that is selected by default.
    """

    save_state: typing.Optional[DropdownComponentSaveState] = pydantic.Field(default=None)
    """
    Styles all options and prevents the action. Default is `unsaved`. Will be overridden if `save_state` is `saved`.
    """

    disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Styles all options and prevents the action. Default is false. Will be overridden if save_state is saved.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
