# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class FileAttribute(UncheckedBaseModel):
    """
    The value describing a file upload set for a custom attribute
    """

    type: str
    name: str = pydantic.Field()
    """
    The name of the file
    """

    url: str = pydantic.Field()
    """
    The url of the file. This is a temporary URL and will expire after 30 minutes.
    """

    content_type: str = pydantic.Field()
    """
    The type of file
    """

    filesize: int = pydantic.Field()
    """
    The size of the file in bytes
    """

    width: int = pydantic.Field()
    """
    The width of the file in pixels, if applicable
    """

    height: int = pydantic.Field()
    """
    The height of the file in pixels, if applicable
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
