# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .group_content import GroupContent


class GroupTranslatedContent(UncheckedBaseModel):
    """
    The Translated Content of an Group. The keys are the locale codes and the values are the translated content of the Group.
    """

    type: typing.Literal["group_translated_content"] = pydantic.Field(default="group_translated_content")
    """
    The type of object - group_translated_content.
    """

    ar: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Arabic
    """

    bg: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Bulgarian
    """

    bs: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Bosnian
    """

    ca: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Catalan
    """

    cs: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Czech
    """

    da: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Danish
    """

    de: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in German
    """

    el: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Greek
    """

    en: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in English
    """

    es: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Spanish
    """

    et: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Estonian
    """

    fi: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Finnish
    """

    fr: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in French
    """

    he: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Hebrew
    """

    hr: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Croatian
    """

    hu: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Hungarian
    """

    id: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Indonesian
    """

    it: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Italian
    """

    ja: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Japanese
    """

    ko: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Korean
    """

    lt: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Lithuanian
    """

    lv: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Latvian
    """

    mn: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Mongolian
    """

    nb: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Norwegian
    """

    nl: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Dutch
    """

    pl: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Polish
    """

    pt: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Portuguese (Portugal)
    """

    ro: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Romanian
    """

    ru: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Russian
    """

    sl: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Slovenian
    """

    sr: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Serbian
    """

    sv: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Swedish
    """

    tr: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Turkish
    """

    vi: typing.Optional[GroupContent] = pydantic.Field(default=None)
    """
    The content of the group in Vietnamese
    """

    pt_br: typing_extensions.Annotated[typing.Optional[GroupContent], FieldMetadata(alias="pt-BR")] = pydantic.Field(
        default=None
    )
    """
    The content of the group in Portuguese (Brazil)
    """

    zh_cn: typing_extensions.Annotated[typing.Optional[GroupContent], FieldMetadata(alias="zh-CN")] = pydantic.Field(
        default=None
    )
    """
    The content of the group in Chinese (China)
    """

    zh_tw: typing_extensions.Annotated[typing.Optional[GroupContent], FieldMetadata(alias="zh-TW")] = pydantic.Field(
        default=None
    )
    """
    The content of the group in Chinese (Taiwan)
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
