# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..admins.types.admin import Admin
from ..contacts.types.contact import Contact
from ..conversations.types.conversation import Conversation
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .context import Context


class InitializeRequest(UncheckedBaseModel):
    """
    The request payload will have all the data needed for you to understand who is using your app, where they are using it, and how you should respond. There are different request payloads for Messenger capabilities and Inbox capabilities.
    """

    workspace_id: str = pydantic.Field()
    """
    The workspace ID of the teammate. Attribute is `app_id` for V1.2 and below.
    """

    workspace_region: str = pydantic.Field()
    """
    The Intercom hosted region that this app is located in.
    """

    admin: Admin = pydantic.Field()
    """
    The Intercom teammate viewing the conversation.
    """

    card_creation_options: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    Key-value pairs which were given as results in response to the Configure request.
    """

    context: Context = pydantic.Field()
    """
    The context of where the app is added, where the user last visited, and information on the Messenger settings.
    """

    conversation: Conversation = pydantic.Field()
    """
    The conversation your app is being shown for.
    """

    contact: Contact = pydantic.Field()
    """
    The contact which is currently being viewed by the teammate in the conversation details panel. We send an individual initialize request for each customer when it's a group conversation.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
