# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .action_component import ActionComponent
from .input_component_save_state import InputComponentSaveState


class InputComponent(UncheckedBaseModel):
    """
    An input component is used to capture text input from the end user. You can submit the value of the input by:

    - Adding an `action` to the input component (which will render an inline button)
    - Using a ButtonComponent (which will submit all interactive components in the canvas)
    """

    id: str = pydantic.Field()
    """
    A unique identifier for the component.
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    The text shown above the input.
    """

    placeholder: typing.Optional[str] = pydantic.Field(default=None)
    """
    An example value shown inside the component when it's empty.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    An entered value which is already inside the component.
    """

    action: typing.Optional[ActionComponent] = pydantic.Field(default=None)
    """
    This can be a Submit Action, URL Action, or Sheets Action.
    """

    save_state: typing.Optional[InputComponentSaveState] = pydantic.Field(default=None)
    """
    Styles the input. Default is `unsaved`. Prevent action with `saved`.
    """

    disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Styles the input and prevents the action. Default is false. Will be overridden if save_state is saved.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
