# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .list_component_items_item import ListComponentItemsItem


class ListComponent(UncheckedBaseModel):
    """
    A list component renders a list of items which you provide in an array. You can make each list item take an action by adding the relevant action object to the item:

    - [Trigger a submit request to be sent](https://developers.intercom.com/docs/references/canvas-kit/actioncomponents/submit-action) Inbox Messenger
    - [Open a link in a new page](https://developers.intercom.com/docs/references/canvas-kit/actioncomponents/url-action) Inbox Messenger
    - [Open a sheet](https://developers.intercom.com/docs/references/canvas-kit/actioncomponents/sheets-action) Messenger
    """

    items: typing.List[ListComponentItemsItem] = pydantic.Field()
    """
    The items that will be rendered in the list.
    """

    disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Styles all list items and prevents the action. Default is `false`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
