# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..contacts.types.contact import Contact
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .canvas_object import CanvasObject
from .context import Context


class LiveCanvasRequest(UncheckedBaseModel):
    """
    Canvases are static by default and require a new request to come through in order to update them. Live canvases however will make requests every time the card is viewed without any interaction needed, meaning the canvas can be kept up-to-date with no action from the user.

    This works for every Messenger request that you can respond with a canvas object to. Instead of returning the content object within the canvas object, you should provide a `content_url` attribute instead with the value being the URL you want us to send a POST request to when someone views the app.
    """

    workspace_id: str = pydantic.Field()
    """
    The workspace ID of the teammate. Attribute is `app_id` for V1.2 and below.
    """

    workspace_region: str = pydantic.Field()
    """
    The Intercom hosted region that this app is located in.
    """

    canvas: CanvasObject = pydantic.Field()
    """
    The current_canvas the teammate can see.
    """

    context: Context = pydantic.Field()
    """
    The context of where the app is added, where the user last visited, and information on the Messenger settings.
    """

    contact: Contact = pydantic.Field()
    """
    The contact who viewed the card.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
