# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class TextAreaComponent(UncheckedBaseModel):
    """
    A text area component is used to capture a large amount of text as input with a multi-line text box. You can submit the value of the text area by:

    - Using a ButtonComponent (which will submit all interactive components in the canvas)
    """

    id: str = pydantic.Field()
    """
    A unique identifier for the component.
    """

    label: typing.Optional[str] = pydantic.Field(default=None)
    """
    The text shown above the text area.
    """

    placeholder: typing.Optional[str] = pydantic.Field(default=None)
    """
    An example value shown inside the component when it's empty.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    An entered value which is already inside the component.
    """

    error: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Styles the input as failed. Default is false.
    """

    disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Styles the input and prevents the action. Default is false.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
