# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.unchecked_base_model import construct_type
from ..errors.unauthorized_error import UnauthorizedError
from ..types.error import Error
from .types.content_import_source import ContentImportSource
from .types.content_import_sources_list import ContentImportSourcesList
from .types.create_content_import_source_request_status import CreateContentImportSourceRequestStatus
from .types.external_page import ExternalPage
from .types.external_pages_list import ExternalPagesList
from .types.update_content_import_source_request_status import UpdateContentImportSourceRequestStatus
from .types.update_content_import_source_request_sync_behavior import UpdateContentImportSourceRequestSyncBehavior

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawAiContentClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_content_import_sources(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ContentImportSourcesList]:
        """
        You can retrieve a list of all content import sources for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ContentImportSourcesList]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "ai/content_import_sources",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ContentImportSourcesList,
                    construct_type(
                        type_=ContentImportSourcesList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_content_import_source(
        self,
        *,
        url: str,
        status: typing.Optional[CreateContentImportSourceRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ContentImportSource]:
        """
        You can create a new content import source by sending a POST request to this endpoint.

        Parameters
        ----------
        url : str
            The URL of the content import source.

        status : typing.Optional[CreateContentImportSourceRequestStatus]
            The status of the content import source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ContentImportSource]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "ai/content_import_sources",
            method="POST",
            json={
                "status": status,
                "url": url,
                "sync_behavior": "api",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ContentImportSource,
                    construct_type(
                        type_=ContentImportSource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_content_import_source(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ContentImportSource]:
        """
        Parameters
        ----------
        id : str
            The unique identifier for the content import source which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ContentImportSource]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ai/content_import_sources/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ContentImportSource,
                    construct_type(
                        type_=ContentImportSource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_content_import_source(
        self,
        id: str,
        *,
        sync_behavior: UpdateContentImportSourceRequestSyncBehavior,
        url: str,
        status: typing.Optional[UpdateContentImportSourceRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ContentImportSource]:
        """
        You can update an existing content import source.

        Parameters
        ----------
        id : str
            The unique identifier for the content import source which is given by Intercom.

        sync_behavior : UpdateContentImportSourceRequestSyncBehavior
            If you intend to create or update External Pages via the API, this should be set to `api`. You can not change the value to or from api.

        url : str
            The URL of the content import source. This may only be different from the existing value if the sync behavior is API.

        status : typing.Optional[UpdateContentImportSourceRequestStatus]
            The status of the content import source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ContentImportSource]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ai/content_import_sources/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "sync_behavior": sync_behavior,
                "status": status,
                "url": url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ContentImportSource,
                    construct_type(
                        type_=ContentImportSource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_content_import_source(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[None]:
        """
        You can delete a content import source by making a DELETE request this endpoint. This will also delete all external pages that were imported from this source.

        Parameters
        ----------
        id : str
            The unique identifier for the content import source which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[None]
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ai/content_import_sources/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return HttpResponse(response=_response, data=None)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_external_pages(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ExternalPagesList]:
        """
        You can retrieve a list of all external pages for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExternalPagesList]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "ai/external_pages",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPagesList,
                    construct_type(
                        type_=ExternalPagesList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_external_page(
        self,
        *,
        title: str,
        html: str,
        source_id: int,
        external_id: str,
        url: typing.Optional[str] = OMIT,
        ai_agent_availability: typing.Optional[bool] = OMIT,
        ai_copilot_availability: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExternalPage]:
        """
        You can create a new external page by sending a POST request to this endpoint. If an external page already exists with the specified source_id and external_id, it will be updated instead.

        Parameters
        ----------
        title : str
            The title of the external page.

        html : str
            The body of the external page in HTML.

        source_id : int
            The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.

        external_id : str
            The identifier for the external page which was given by the source. Must be unique for the source.

        url : typing.Optional[str]
            The URL of the external page. This will be used by Fin to link end users to the page it based its answer on. When a URL is not present, Fin will not reference the source.

        ai_agent_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by AI Agent. Will not default when updating an existing external page.

        ai_copilot_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by AI Copilot. Will not default when updating an existing external page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExternalPage]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "ai/external_pages",
            method="POST",
            json={
                "title": title,
                "html": html,
                "url": url,
                "ai_agent_availability": ai_agent_availability,
                "ai_copilot_availability": ai_copilot_availability,
                "source_id": source_id,
                "external_id": external_id,
                "locale": "en",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPage,
                    construct_type(
                        type_=ExternalPage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_external_page(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ExternalPage]:
        """
        You can retrieve an external page.

        Parameters
        ----------
        id : str
            The unique identifier for the external page which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExternalPage]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ai/external_pages/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPage,
                    construct_type(
                        type_=ExternalPage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update_external_page(
        self,
        id: str,
        *,
        title: str,
        html: str,
        url: str,
        source_id: int,
        fin_availability: typing.Optional[bool] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ExternalPage]:
        """
        You can update an existing external page (if it was created via the API).

        Parameters
        ----------
        id : str
            The unique identifier for the external page which is given by Intercom.

        title : str
            The title of the external page.

        html : str
            The body of the external page in HTML.

        url : str
            The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.

        source_id : int
            The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.

        fin_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by Fin.

        external_id : typing.Optional[str]
            The identifier for the external page which was given by the source. Must be unique for the source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExternalPage]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ai/external_pages/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "title": title,
                "html": html,
                "url": url,
                "fin_availability": fin_availability,
                "source_id": source_id,
                "external_id": external_id,
                "locale": "en",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPage,
                    construct_type(
                        type_=ExternalPage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_external_page(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ExternalPage]:
        """
        Sending a DELETE request for an external page will remove it from the content library UI and from being used for AI answers.

        Parameters
        ----------
        id : str
            The unique identifier for the external page which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ExternalPage]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"ai/external_pages/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPage,
                    construct_type(
                        type_=ExternalPage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawAiContentClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_content_import_sources(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ContentImportSourcesList]:
        """
        You can retrieve a list of all content import sources for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ContentImportSourcesList]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ai/content_import_sources",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ContentImportSourcesList,
                    construct_type(
                        type_=ContentImportSourcesList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_content_import_source(
        self,
        *,
        url: str,
        status: typing.Optional[CreateContentImportSourceRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ContentImportSource]:
        """
        You can create a new content import source by sending a POST request to this endpoint.

        Parameters
        ----------
        url : str
            The URL of the content import source.

        status : typing.Optional[CreateContentImportSourceRequestStatus]
            The status of the content import source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ContentImportSource]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ai/content_import_sources",
            method="POST",
            json={
                "status": status,
                "url": url,
                "sync_behavior": "api",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ContentImportSource,
                    construct_type(
                        type_=ContentImportSource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_content_import_source(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ContentImportSource]:
        """
        Parameters
        ----------
        id : str
            The unique identifier for the content import source which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ContentImportSource]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ai/content_import_sources/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ContentImportSource,
                    construct_type(
                        type_=ContentImportSource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_content_import_source(
        self,
        id: str,
        *,
        sync_behavior: UpdateContentImportSourceRequestSyncBehavior,
        url: str,
        status: typing.Optional[UpdateContentImportSourceRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ContentImportSource]:
        """
        You can update an existing content import source.

        Parameters
        ----------
        id : str
            The unique identifier for the content import source which is given by Intercom.

        sync_behavior : UpdateContentImportSourceRequestSyncBehavior
            If you intend to create or update External Pages via the API, this should be set to `api`. You can not change the value to or from api.

        url : str
            The URL of the content import source. This may only be different from the existing value if the sync behavior is API.

        status : typing.Optional[UpdateContentImportSourceRequestStatus]
            The status of the content import source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ContentImportSource]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ai/content_import_sources/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "sync_behavior": sync_behavior,
                "status": status,
                "url": url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ContentImportSource,
                    construct_type(
                        type_=ContentImportSource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_content_import_source(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[None]:
        """
        You can delete a content import source by making a DELETE request this endpoint. This will also delete all external pages that were imported from this source.

        Parameters
        ----------
        id : str
            The unique identifier for the content import source which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[None]
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ai/content_import_sources/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                return AsyncHttpResponse(response=_response, data=None)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_external_pages(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ExternalPagesList]:
        """
        You can retrieve a list of all external pages for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExternalPagesList]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ai/external_pages",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPagesList,
                    construct_type(
                        type_=ExternalPagesList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_external_page(
        self,
        *,
        title: str,
        html: str,
        source_id: int,
        external_id: str,
        url: typing.Optional[str] = OMIT,
        ai_agent_availability: typing.Optional[bool] = OMIT,
        ai_copilot_availability: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExternalPage]:
        """
        You can create a new external page by sending a POST request to this endpoint. If an external page already exists with the specified source_id and external_id, it will be updated instead.

        Parameters
        ----------
        title : str
            The title of the external page.

        html : str
            The body of the external page in HTML.

        source_id : int
            The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.

        external_id : str
            The identifier for the external page which was given by the source. Must be unique for the source.

        url : typing.Optional[str]
            The URL of the external page. This will be used by Fin to link end users to the page it based its answer on. When a URL is not present, Fin will not reference the source.

        ai_agent_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by AI Agent. Will not default when updating an existing external page.

        ai_copilot_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by AI Copilot. Will not default when updating an existing external page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExternalPage]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "ai/external_pages",
            method="POST",
            json={
                "title": title,
                "html": html,
                "url": url,
                "ai_agent_availability": ai_agent_availability,
                "ai_copilot_availability": ai_copilot_availability,
                "source_id": source_id,
                "external_id": external_id,
                "locale": "en",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPage,
                    construct_type(
                        type_=ExternalPage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_external_page(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ExternalPage]:
        """
        You can retrieve an external page.

        Parameters
        ----------
        id : str
            The unique identifier for the external page which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExternalPage]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ai/external_pages/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPage,
                    construct_type(
                        type_=ExternalPage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update_external_page(
        self,
        id: str,
        *,
        title: str,
        html: str,
        url: str,
        source_id: int,
        fin_availability: typing.Optional[bool] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ExternalPage]:
        """
        You can update an existing external page (if it was created via the API).

        Parameters
        ----------
        id : str
            The unique identifier for the external page which is given by Intercom.

        title : str
            The title of the external page.

        html : str
            The body of the external page in HTML.

        url : str
            The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.

        source_id : int
            The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.

        fin_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by Fin.

        external_id : typing.Optional[str]
            The identifier for the external page which was given by the source. Must be unique for the source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExternalPage]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ai/external_pages/{jsonable_encoder(id)}",
            method="PUT",
            json={
                "title": title,
                "html": html,
                "url": url,
                "fin_availability": fin_availability,
                "source_id": source_id,
                "external_id": external_id,
                "locale": "en",
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPage,
                    construct_type(
                        type_=ExternalPage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_external_page(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ExternalPage]:
        """
        Sending a DELETE request for an external page will remove it from the content library UI and from being used for AI answers.

        Parameters
        ----------
        id : str
            The unique identifier for the external page which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ExternalPage]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"ai/external_pages/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ExternalPage,
                    construct_type(
                        type_=ExternalPage,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
