# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.article_list import ArticleList
from ..types.deleted_article_object import DeletedArticleObject
from .raw_client import AsyncRawArticlesClient, RawArticlesClient
from .types.article import Article
from .types.article_search_response import ArticleSearchResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ArticlesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawArticlesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawArticlesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawArticlesClient
        """
        return self._raw_client

    def list_articles(self, *, request_options: typing.Optional[RequestOptions] = None) -> ArticleList:
        """
        You can fetch a list of all articles by making a GET request to `https://api.intercom.io/articles`.

        > 📘 How are the articles sorted and ordered?
        >
        > Articles will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ArticleList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.articles.list_articles()
        """
        _response = self._raw_client.list_articles(request_options=request_options)
        return _response.data

    def create_article(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> Article:
        """
        You can create a new article by making a POST request to `https://api.intercom.io/articles`.

        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            article created

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.articles.create_article(
            request={"key": "value"},
        )
        """
        _response = self._raw_client.create_article(request=request, request_options=request_options)
        return _response.data

    def retrieve_article(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Article:
        """
        You can fetch the details of a single article by making a GET request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            Article found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.articles.retrieve_article(
            id=1,
        )
        """
        _response = self._raw_client.retrieve_article(id, request_options=request_options)
        return _response.data

    def delete_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedArticleObject:
        """
        You can delete a single article by making a DELETE request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedArticleObject
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.articles.delete_article(
            id=1,
        )
        """
        _response = self._raw_client.delete_article(id, request_options=request_options)
        return _response.data

    def search_articles(
        self,
        *,
        phrase: typing.Optional[str] = None,
        state: typing.Optional[str] = None,
        help_center_id: typing.Optional[int] = None,
        highlight: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ArticleSearchResponse:
        """
        You can search for articles by making a GET request to `https://api.intercom.io/articles/search`.

        Parameters
        ----------
        phrase : typing.Optional[str]
            The phrase within your articles to search for.

        state : typing.Optional[str]
            The state of the Articles returned. One of `published`, `draft` or `all`.

        help_center_id : typing.Optional[int]
            The ID of the Help Center to search in.

        highlight : typing.Optional[bool]
            Return a highlighted version of the matching content within your articles. Refer to the response schema for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ArticleSearchResponse
            Search successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.articles.search_articles(
            phrase="Getting started",
            state="published",
        )
        """
        _response = self._raw_client.search_articles(
            phrase=phrase,
            state=state,
            help_center_id=help_center_id,
            highlight=highlight,
            request_options=request_options,
        )
        return _response.data


class AsyncArticlesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawArticlesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawArticlesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawArticlesClient
        """
        return self._raw_client

    async def list_articles(self, *, request_options: typing.Optional[RequestOptions] = None) -> ArticleList:
        """
        You can fetch a list of all articles by making a GET request to `https://api.intercom.io/articles`.

        > 📘 How are the articles sorted and ordered?
        >
        > Articles will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ArticleList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.articles.list_articles()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_articles(request_options=request_options)
        return _response.data

    async def create_article(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> Article:
        """
        You can create a new article by making a POST request to `https://api.intercom.io/articles`.

        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            article created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.articles.create_article(
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_article(request=request, request_options=request_options)
        return _response.data

    async def retrieve_article(self, id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Article:
        """
        You can fetch the details of a single article by making a GET request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            Article found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.articles.retrieve_article(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_article(id, request_options=request_options)
        return _response.data

    async def delete_article(
        self, id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedArticleObject:
        """
        You can delete a single article by making a DELETE request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedArticleObject
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.articles.delete_article(
                id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_article(id, request_options=request_options)
        return _response.data

    async def search_articles(
        self,
        *,
        phrase: typing.Optional[str] = None,
        state: typing.Optional[str] = None,
        help_center_id: typing.Optional[int] = None,
        highlight: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ArticleSearchResponse:
        """
        You can search for articles by making a GET request to `https://api.intercom.io/articles/search`.

        Parameters
        ----------
        phrase : typing.Optional[str]
            The phrase within your articles to search for.

        state : typing.Optional[str]
            The state of the Articles returned. One of `published`, `draft` or `all`.

        help_center_id : typing.Optional[int]
            The ID of the Help Center to search in.

        highlight : typing.Optional[bool]
            Return a highlighted version of the matching content within your articles. Refer to the response schema for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ArticleSearchResponse
            Search successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.articles.search_articles(
                phrase="Getting started",
                state="published",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_articles(
            phrase=phrase,
            state=state,
            help_center_id=help_center_id,
            highlight=highlight,
            request_options=request_options,
        )
        return _response.data
