# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.company_attached_contacts import CompanyAttachedContacts
from ..types.company_attached_segments import CompanyAttachedSegments
from ..types.company_list import CompanyList
from ..types.company_scroll import CompanyScroll
from ..types.deleted_company_object import DeletedCompanyObject
from .raw_client import AsyncRawCompaniesClient, RawCompaniesClient
from .types.company import Company

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CompaniesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCompaniesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCompaniesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCompaniesClient
        """
        return self._raw_client

    def retrieve_company(
        self,
        *,
        name: typing.Optional[str] = None,
        company_id: typing.Optional[str] = None,
        tag_id: typing.Optional[str] = None,
        segment_id: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CompanyList:
        """
        You can fetch a single company by passing in `company_id` or `name`.

          `https://api.intercom.io/companies?name={name}`

          `https://api.intercom.io/companies?company_id={company_id}`

        You can fetch all companies and filter by `segment_id` or `tag_id` as a query parameter.

          `https://api.intercom.io/companies?tag_id={tag_id}`

          `https://api.intercom.io/companies?segment_id={segment_id}`

        Parameters
        ----------
        name : typing.Optional[str]
            The `name` of the company to filter by.

        company_id : typing.Optional[str]
            The `company_id` of the company to filter by.

        tag_id : typing.Optional[str]
            The `tag_id` of the company to filter by.

        segment_id : typing.Optional[str]
            The `segment_id` of the company to filter by.

        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CompanyList
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.retrieve_company(
            name="my company",
            company_id="12345",
            tag_id="678910",
            segment_id="98765",
        )
        """
        _response = self._raw_client.retrieve_company(
            name=name,
            company_id=company_id,
            tag_id=tag_id,
            segment_id=segment_id,
            page=page,
            per_page=per_page,
            request_options=request_options,
        )
        return _response.data

    def create_or_update_company(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> Company:
        """
        You can create or update a company.

        Companies will be only visible in Intercom when there is at least one associated user.

        Companies are looked up via `company_id` in a `POST` request, if not found via `company_id`, the new company will be created, if found, that company will be updated.

        {% admonition type="warning" name="Using `company_id`" %}
          You can set a unique `company_id` value when creating a company. However, it is not possible to update `company_id`. Be sure to set a unique value once upon creation of the company.
        {% /admonition %}

        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.create_or_update_company(
            request={"key": "value"},
        )
        """
        _response = self._raw_client.create_or_update_company(request=request, request_options=request_options)
        return _response.data

    def retrieve_a_company_by_id(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Company:
        """
        You can fetch a single company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.retrieve_a_company_by_id(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )
        """
        _response = self._raw_client.retrieve_a_company_by_id(id, request_options=request_options)
        return _response.data

    def update_company(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Company:
        """
        You can update a single company using the Intercom provisioned `id`.

        {% admonition type="warning" name="Using `company_id`" %}
          When updating a company it is not possible to update `company_id`. This can only be set once upon creation of the company.
        {% /admonition %}

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.update_company(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )
        """
        _response = self._raw_client.update_company(id, request_options=request_options)
        return _response.data

    def delete_company(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedCompanyObject:
        """
        You can delete a single company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedCompanyObject
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.delete_company(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )
        """
        _response = self._raw_client.delete_company(id, request_options=request_options)
        return _response.data

    def list_attached_contacts(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CompanyAttachedContacts:
        """
        You can fetch a list of all contacts that belong to a company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CompanyAttachedContacts
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.list_attached_contacts(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )
        """
        _response = self._raw_client.list_attached_contacts(id, request_options=request_options)
        return _response.data

    def list_attached_segments_for_companies(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CompanyAttachedSegments:
        """
        You can fetch a list of all segments that belong to a company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CompanyAttachedSegments
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.list_attached_segments_for_companies(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )
        """
        _response = self._raw_client.list_attached_segments_for_companies(id, request_options=request_options)
        return _response.data

    def list_all_companies(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        order: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CompanyList:
        """
        You can list companies. The company list is sorted by the `last_request_at` field and by default is ordered descending, most recently requested first.

        Note that the API does not include companies who have no associated users in list responses.

        When using the Companies endpoint and the pages object to iterate through the returned companies, there is a limit of 10,000 Companies that can be returned. If you need to list or iterate on more than 10,000 Companies, please use the [Scroll API](https://developers.intercom.com/reference#iterating-over-all-companies).
        {% admonition type="warning" name="Pagination" %}
          You can use pagination to limit the number of results returned. The default is `20` results per page.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis) for more details on how to use the `starting_after` param.
        {% /admonition %}

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to return per page. Defaults to 15

        order : typing.Optional[str]
            `asc` or `desc`. Return the companies in ascending or descending order. Defaults to desc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CompanyList
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.list_all_companies(
            order="desc",
        )
        """
        _response = self._raw_client.list_all_companies(
            page=page, per_page=per_page, order=order, request_options=request_options
        )
        return _response.data

    def scroll_over_all_companies(
        self, *, scroll_param: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[CompanyScroll]:
        """
              The `list all companies` functionality does not work well for huge datasets, and can result in errors and performance problems when paging deeply. The Scroll API provides an efficient mechanism for iterating over all companies in a dataset.

        - Each app can only have 1 scroll open at a time. You'll get an error message if you try to have more than one open per app.
        - If the scroll isn't used for 1 minute, it expires and calls with that scroll param will fail
        - If the end of the scroll is reached, "companies" will be empty and the scroll parameter will expire

        {% admonition type="info" name="Scroll Parameter" %}
          You can get the first page of companies by simply sending a GET request to the scroll endpoint.
          For subsequent requests you will need to use the scroll parameter from the response.
        {% /admonition %}
        {% admonition type="danger" name="Scroll network timeouts" %}
          Since scroll is often used on large datasets network errors such as timeouts can be encountered. When this occurs you will see a HTTP 500 error with the following message:
          "Request failed due to an internal network error. Please restart the scroll operation."
          If this happens, you will need to restart your scroll query: It is not possible to continue from a specific point when using scroll.
        {% /admonition %}

        Parameters
        ----------
        scroll_param : typing.Optional[str]


        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CompanyScroll]
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.scroll_over_all_companies()
        """
        _response = self._raw_client.scroll_over_all_companies(
            scroll_param=scroll_param, request_options=request_options
        )
        return _response.data

    def attach_contact_to_a_company(
        self, id: str, *, company_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Company:
        """
        You can attach a company to a single contact.

        Parameters
        ----------
        id : str
            The unique identifier for the contact which is given by Intercom

        company_id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.attach_contact_to_a_company(
            id="id",
            company_id="6762f09a1bb69f9f2193bb34",
        )
        """
        _response = self._raw_client.attach_contact_to_a_company(
            id, company_id=company_id, request_options=request_options
        )
        return _response.data

    def detach_contact_from_a_company(
        self, contact_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Company:
        """
        You can detach a company from a single contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.companies.detach_contact_from_a_company(
            contact_id="58a430d35458202d41b1e65b",
            id="58a430d35458202d41b1e65b",
        )
        """
        _response = self._raw_client.detach_contact_from_a_company(contact_id, id, request_options=request_options)
        return _response.data


class AsyncCompaniesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCompaniesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCompaniesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCompaniesClient
        """
        return self._raw_client

    async def retrieve_company(
        self,
        *,
        name: typing.Optional[str] = None,
        company_id: typing.Optional[str] = None,
        tag_id: typing.Optional[str] = None,
        segment_id: typing.Optional[str] = None,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CompanyList:
        """
        You can fetch a single company by passing in `company_id` or `name`.

          `https://api.intercom.io/companies?name={name}`

          `https://api.intercom.io/companies?company_id={company_id}`

        You can fetch all companies and filter by `segment_id` or `tag_id` as a query parameter.

          `https://api.intercom.io/companies?tag_id={tag_id}`

          `https://api.intercom.io/companies?segment_id={segment_id}`

        Parameters
        ----------
        name : typing.Optional[str]
            The `name` of the company to filter by.

        company_id : typing.Optional[str]
            The `company_id` of the company to filter by.

        tag_id : typing.Optional[str]
            The `tag_id` of the company to filter by.

        segment_id : typing.Optional[str]
            The `segment_id` of the company to filter by.

        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CompanyList
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.retrieve_company(
                name="my company",
                company_id="12345",
                tag_id="678910",
                segment_id="98765",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_company(
            name=name,
            company_id=company_id,
            tag_id=tag_id,
            segment_id=segment_id,
            page=page,
            per_page=per_page,
            request_options=request_options,
        )
        return _response.data

    async def create_or_update_company(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> Company:
        """
        You can create or update a company.

        Companies will be only visible in Intercom when there is at least one associated user.

        Companies are looked up via `company_id` in a `POST` request, if not found via `company_id`, the new company will be created, if found, that company will be updated.

        {% admonition type="warning" name="Using `company_id`" %}
          You can set a unique `company_id` value when creating a company. However, it is not possible to update `company_id`. Be sure to set a unique value once upon creation of the company.
        {% /admonition %}

        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.create_or_update_company(
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_or_update_company(request=request, request_options=request_options)
        return _response.data

    async def retrieve_a_company_by_id(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Company:
        """
        You can fetch a single company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.retrieve_a_company_by_id(
                id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_a_company_by_id(id, request_options=request_options)
        return _response.data

    async def update_company(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Company:
        """
        You can update a single company using the Intercom provisioned `id`.

        {% admonition type="warning" name="Using `company_id`" %}
          When updating a company it is not possible to update `company_id`. This can only be set once upon creation of the company.
        {% /admonition %}

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.update_company(
                id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_company(id, request_options=request_options)
        return _response.data

    async def delete_company(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedCompanyObject:
        """
        You can delete a single company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedCompanyObject
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.delete_company(
                id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_company(id, request_options=request_options)
        return _response.data

    async def list_attached_contacts(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CompanyAttachedContacts:
        """
        You can fetch a list of all contacts that belong to a company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CompanyAttachedContacts
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.list_attached_contacts(
                id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_attached_contacts(id, request_options=request_options)
        return _response.data

    async def list_attached_segments_for_companies(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> CompanyAttachedSegments:
        """
        You can fetch a list of all segments that belong to a company.

        Parameters
        ----------
        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CompanyAttachedSegments
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.list_attached_segments_for_companies(
                id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_attached_segments_for_companies(id, request_options=request_options)
        return _response.data

    async def list_all_companies(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        order: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CompanyList:
        """
        You can list companies. The company list is sorted by the `last_request_at` field and by default is ordered descending, most recently requested first.

        Note that the API does not include companies who have no associated users in list responses.

        When using the Companies endpoint and the pages object to iterate through the returned companies, there is a limit of 10,000 Companies that can be returned. If you need to list or iterate on more than 10,000 Companies, please use the [Scroll API](https://developers.intercom.com/reference#iterating-over-all-companies).
        {% admonition type="warning" name="Pagination" %}
          You can use pagination to limit the number of results returned. The default is `20` results per page.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#pagination-for-list-apis) for more details on how to use the `starting_after` param.
        {% /admonition %}

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to return per page. Defaults to 15

        order : typing.Optional[str]
            `asc` or `desc`. Return the companies in ascending or descending order. Defaults to desc

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CompanyList
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.list_all_companies(
                order="desc",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_all_companies(
            page=page, per_page=per_page, order=order, request_options=request_options
        )
        return _response.data

    async def scroll_over_all_companies(
        self, *, scroll_param: typing.Optional[str] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[CompanyScroll]:
        """
              The `list all companies` functionality does not work well for huge datasets, and can result in errors and performance problems when paging deeply. The Scroll API provides an efficient mechanism for iterating over all companies in a dataset.

        - Each app can only have 1 scroll open at a time. You'll get an error message if you try to have more than one open per app.
        - If the scroll isn't used for 1 minute, it expires and calls with that scroll param will fail
        - If the end of the scroll is reached, "companies" will be empty and the scroll parameter will expire

        {% admonition type="info" name="Scroll Parameter" %}
          You can get the first page of companies by simply sending a GET request to the scroll endpoint.
          For subsequent requests you will need to use the scroll parameter from the response.
        {% /admonition %}
        {% admonition type="danger" name="Scroll network timeouts" %}
          Since scroll is often used on large datasets network errors such as timeouts can be encountered. When this occurs you will see a HTTP 500 error with the following message:
          "Request failed due to an internal network error. Please restart the scroll operation."
          If this happens, you will need to restart your scroll query: It is not possible to continue from a specific point when using scroll.
        {% /admonition %}

        Parameters
        ----------
        scroll_param : typing.Optional[str]


        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CompanyScroll]
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.scroll_over_all_companies()


        asyncio.run(main())
        """
        _response = await self._raw_client.scroll_over_all_companies(
            scroll_param=scroll_param, request_options=request_options
        )
        return _response.data

    async def attach_contact_to_a_company(
        self, id: str, *, company_id: str, request_options: typing.Optional[RequestOptions] = None
    ) -> Company:
        """
        You can attach a company to a single contact.

        Parameters
        ----------
        id : str
            The unique identifier for the contact which is given by Intercom

        company_id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.attach_contact_to_a_company(
                id="id",
                company_id="6762f09a1bb69f9f2193bb34",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.attach_contact_to_a_company(
            id, company_id=company_id, request_options=request_options
        )
        return _response.data

    async def detach_contact_from_a_company(
        self, contact_id: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> Company:
        """
        You can detach a company from a single contact.

        Parameters
        ----------
        contact_id : str
            The unique identifier for the contact which is given by Intercom

        id : str
            The unique identifier for the company which is given by Intercom

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Company
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.companies.detach_contact_from_a_company(
                contact_id="58a430d35458202d41b1e65b",
                id="58a430d35458202d41b1e65b",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.detach_contact_from_a_company(
            contact_id, id, request_options=request_options
        )
        return _response.data
