# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ...core.api_error import ApiError
from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.http_response import AsyncHttpResponse, HttpResponse
from ...core.jsonable_encoder import jsonable_encoder
from ...core.request_options import RequestOptions
from ...core.unchecked_base_model import construct_type
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.custom_object_instance_deleted import CustomObjectInstanceDeleted
from ..types.error import Error
from .types.custom_object_instance import CustomObjectInstance

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCustomObjectInstancesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def get_custom_object_instances_by_external_id(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[CustomObjectInstance]]:
        """
        Fetch a Custom Object Instance by external_id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[CustomObjectInstance]]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}",
            method="GET",
            params={
                "external_id": external_id,
            },
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[CustomObjectInstance],
                    construct_type(
                        type_=typing.Optional[CustomObjectInstance],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_custom_object_instances(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: typing.Optional[str] = OMIT,
        external_created_at: typing.Optional[int] = OMIT,
        external_updated_at: typing.Optional[int] = OMIT,
        custom_attributes: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[CustomObjectInstance]]:
        """
        Create or update a custom object instance

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : typing.Optional[str]
            A unique identifier for the Custom Object instance in the external system it originated from.

        external_created_at : typing.Optional[int]
            The time when the Custom Object instance was created in the external system it originated from.

        external_updated_at : typing.Optional[int]
            The time when the Custom Object instance was last updated in the external system it originated from.

        custom_attributes : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            The custom attributes which are set for the Custom Object instance.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[CustomObjectInstance]]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}",
            method="POST",
            json={
                "external_id": external_id,
                "external_created_at": external_created_at,
                "external_updated_at": external_updated_at,
                "custom_attributes": custom_attributes,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[CustomObjectInstance],
                    construct_type(
                        type_=typing.Optional[CustomObjectInstance],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_custom_object_instances_by_id(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CustomObjectInstanceDeleted]:
        """
        Delete a single Custom Object instance by external_id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomObjectInstanceDeleted]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}",
            method="DELETE",
            params={
                "external_id": external_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomObjectInstanceDeleted,
                    construct_type(
                        type_=CustomObjectInstanceDeleted,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_custom_object_instances_by_id(
        self, custom_object_type_identifier: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[typing.Optional[CustomObjectInstance]]:
        """
        Fetch a Custom Object Instance by id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        id : str
            The id or external_id of the custom object instance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[CustomObjectInstance]]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[CustomObjectInstance],
                    construct_type(
                        type_=typing.Optional[CustomObjectInstance],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete_custom_object_instances_by_external_id(
        self, custom_object_type_identifier: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CustomObjectInstanceDeleted]:
        """
        Delete a single Custom Object instance using the Intercom defined id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        id : str
            The Intercom defined id of the custom object instance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CustomObjectInstanceDeleted]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomObjectInstanceDeleted,
                    construct_type(
                        type_=CustomObjectInstanceDeleted,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCustomObjectInstancesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def get_custom_object_instances_by_external_id(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[CustomObjectInstance]]:
        """
        Fetch a Custom Object Instance by external_id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[CustomObjectInstance]]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}",
            method="GET",
            params={
                "external_id": external_id,
            },
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[CustomObjectInstance],
                    construct_type(
                        type_=typing.Optional[CustomObjectInstance],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_custom_object_instances(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: typing.Optional[str] = OMIT,
        external_created_at: typing.Optional[int] = OMIT,
        external_updated_at: typing.Optional[int] = OMIT,
        custom_attributes: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[CustomObjectInstance]]:
        """
        Create or update a custom object instance

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : typing.Optional[str]
            A unique identifier for the Custom Object instance in the external system it originated from.

        external_created_at : typing.Optional[int]
            The time when the Custom Object instance was created in the external system it originated from.

        external_updated_at : typing.Optional[int]
            The time when the Custom Object instance was last updated in the external system it originated from.

        custom_attributes : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            The custom attributes which are set for the Custom Object instance.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[CustomObjectInstance]]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}",
            method="POST",
            json={
                "external_id": external_id,
                "external_created_at": external_created_at,
                "external_updated_at": external_updated_at,
                "custom_attributes": custom_attributes,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[CustomObjectInstance],
                    construct_type(
                        type_=typing.Optional[CustomObjectInstance],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_custom_object_instances_by_id(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CustomObjectInstanceDeleted]:
        """
        Delete a single Custom Object instance by external_id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomObjectInstanceDeleted]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}",
            method="DELETE",
            params={
                "external_id": external_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomObjectInstanceDeleted,
                    construct_type(
                        type_=CustomObjectInstanceDeleted,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_custom_object_instances_by_id(
        self, custom_object_type_identifier: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[typing.Optional[CustomObjectInstance]]:
        """
        Fetch a Custom Object Instance by id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        id : str
            The id or external_id of the custom object instance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[CustomObjectInstance]]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}/{jsonable_encoder(id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[CustomObjectInstance],
                    construct_type(
                        type_=typing.Optional[CustomObjectInstance],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete_custom_object_instances_by_external_id(
        self, custom_object_type_identifier: str, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CustomObjectInstanceDeleted]:
        """
        Delete a single Custom Object instance using the Intercom defined id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        id : str
            The Intercom defined id of the custom object instance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CustomObjectInstanceDeleted]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"custom_object_instances/{jsonable_encoder(custom_object_type_identifier)}/{jsonable_encoder(id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CustomObjectInstanceDeleted,
                    construct_type(
                        type_=CustomObjectInstanceDeleted,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Optional[typing.Any],
                        construct_type(
                            type_=typing.Optional[typing.Any],  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
