# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ...types.create_message_request_three import CreateMessageRequestThree
from ..types.whatsapp_message_status_list import WhatsappMessageStatusList
from .raw_client import AsyncRawMessagesClient, RawMessagesClient
from .types.message import Message

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class MessagesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawMessagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawMessagesClient
        """
        return self._raw_client

    def create_message(
        self, *, request: CreateMessageRequestThree, request_options: typing.Optional[RequestOptions] = None
    ) -> Message:
        """
        You can create a message that has been initiated by an admin. The conversation can be either an in-app message, an email, sms or whatsapp.

        > 🚧 Sending for visitors
        >
        > There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.

        This will return the Message model that has been created.

        > 🚧 Retrieving Associated Conversations
        >
        > As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.

        Parameters
        ----------
        request : CreateMessageRequestThree

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            admin message created

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.messages.create_message(
            request={
                "from": {"type": "user", "id": "6762f2341bb69f9f2193bc17"},
                "body": "heyy",
                "referer": "https://twitter.com/bob",
            },
        )
        """
        _response = self._raw_client.create_message(request=request, request_options=request_options)
        return _response.data

    def get_whats_app_message_status(
        self,
        *,
        ruleset_id: str,
        per_page: typing.Optional[int] = None,
        starting_after: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhatsappMessageStatusList:
        """
        Retrieves statuses of messages sent from the Outbound module. Currently, this API only supports WhatsApp messages.


        This endpoint returns paginated status events for WhatsApp messages sent via the Outbound module, providing
        information about delivery state and related message details.

        Parameters
        ----------
        ruleset_id : str
            The unique identifier for the set of messages to check status for

        per_page : typing.Optional[int]
            Number of results per page (default 50, max 100)

        starting_after : typing.Optional[str]
            Cursor for pagination, used to fetch the next page of results

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhatsappMessageStatusList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.messages.get_whats_app_message_status(
            ruleset_id="ruleset_id",
        )
        """
        _response = self._raw_client.get_whats_app_message_status(
            ruleset_id=ruleset_id, per_page=per_page, starting_after=starting_after, request_options=request_options
        )
        return _response.data


class AsyncMessagesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawMessagesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawMessagesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawMessagesClient
        """
        return self._raw_client

    async def create_message(
        self, *, request: CreateMessageRequestThree, request_options: typing.Optional[RequestOptions] = None
    ) -> Message:
        """
        You can create a message that has been initiated by an admin. The conversation can be either an in-app message, an email, sms or whatsapp.

        > 🚧 Sending for visitors
        >
        > There can be a short delay between when a contact is created and when a contact becomes available to be messaged through the API. A 404 Not Found error will be returned in this case.

        This will return the Message model that has been created.

        > 🚧 Retrieving Associated Conversations
        >
        > As this is a message, there will be no conversation present until the contact responds. Once they do, you will have to search for a contact's conversations with the id of the message.

        Parameters
        ----------
        request : CreateMessageRequestThree

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Message
            admin message created

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.messages.create_message(
                request={
                    "from": {"type": "user", "id": "6762f2341bb69f9f2193bc17"},
                    "body": "heyy",
                    "referer": "https://twitter.com/bob",
                },
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_message(request=request, request_options=request_options)
        return _response.data

    async def get_whats_app_message_status(
        self,
        *,
        ruleset_id: str,
        per_page: typing.Optional[int] = None,
        starting_after: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> WhatsappMessageStatusList:
        """
        Retrieves statuses of messages sent from the Outbound module. Currently, this API only supports WhatsApp messages.


        This endpoint returns paginated status events for WhatsApp messages sent via the Outbound module, providing
        information about delivery state and related message details.

        Parameters
        ----------
        ruleset_id : str
            The unique identifier for the set of messages to check status for

        per_page : typing.Optional[int]
            Number of results per page (default 50, max 100)

        starting_after : typing.Optional[str]
            Cursor for pagination, used to fetch the next page of results

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WhatsappMessageStatusList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.messages.get_whats_app_message_status(
                ruleset_id="ruleset_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_whats_app_message_status(
            ruleset_id=ruleset_id, per_page=per_page, starting_after=starting_after, request_options=request_options
        )
        return _response.data
