# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.phone_switch import PhoneSwitch
from .raw_client import AsyncRawSwitchClient, RawSwitchClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SwitchClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSwitchClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSwitchClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSwitchClient
        """
        return self._raw_client

    def create_phone_switch(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[PhoneSwitch]:
        """
        You can use the API to deflect phone calls to the Intercom Messenger.
        Calling this endpoint will send an SMS with a link to the Messenger to the phone number specified.

        If custom attributes are specified, they will be added to the user or lead's custom data attributes.

        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[PhoneSwitch]
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.switch.create_phone_switch(
            request={"key": "value"},
        )
        """
        _response = self._raw_client.create_phone_switch(request=request, request_options=request_options)
        return _response.data


class AsyncSwitchClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSwitchClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSwitchClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSwitchClient
        """
        return self._raw_client

    async def create_phone_switch(
        self, *, request: typing.Optional[typing.Any] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[PhoneSwitch]:
        """
        You can use the API to deflect phone calls to the Intercom Messenger.
        Calling this endpoint will send an SMS with a link to the Messenger to the phone number specified.

        If custom attributes are specified, they will be added to the user or lead's custom data attributes.

        Parameters
        ----------
        request : typing.Optional[typing.Any]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[PhoneSwitch]
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.switch.create_phone_switch(
                request={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_phone_switch(request=request, request_options=request_options)
        return _response.data
