# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..jobs.types.jobs import Jobs
from ..types.create_ticket_request_assignment import CreateTicketRequestAssignment
from ..types.create_ticket_request_contacts_item import CreateTicketRequestContactsItem
from ..types.search_request_query import SearchRequestQuery
from ..types.starting_after_paging import StartingAfterPaging
from ..types.ticket_list import TicketList
from ..types.ticket_reply import TicketReply
from .raw_client import AsyncRawTicketsClient, RawTicketsClient
from .types.delete_ticket_response import DeleteTicketResponse
from .types.reply_ticket_request_body import ReplyTicketRequestBody
from .types.ticket import Ticket

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class TicketsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTicketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTicketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTicketsClient
        """
        return self._raw_client

    def reply_ticket(
        self, id: str, *, request: ReplyTicketRequestBody, request_options: typing.Optional[RequestOptions] = None
    ) -> TicketReply:
        """
        You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.

        Parameters
        ----------
        id : str

        request : ReplyTicketRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketReply
            Admin Reply to send Quick Reply Options

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import ContactReplyTicketIntercomUserIdRequest

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tickets.reply_ticket(
            id="123",
            request=ContactReplyTicketIntercomUserIdRequest(
                body="Thanks again :)",
                intercom_user_id="6762f2971bb69f9f2193bc49",
            ),
        )
        """
        _response = self._raw_client.reply_ticket(id, request=request, request_options=request_options)
        return _response.data

    def enqueue_create_ticket(
        self,
        *,
        ticket_type_id: str,
        contacts: typing.Sequence[CreateTicketRequestContactsItem],
        skip_notifications: typing.Optional[bool] = OMIT,
        conversation_to_link_id: typing.Optional[str] = OMIT,
        company_id: typing.Optional[str] = OMIT,
        created_at: typing.Optional[int] = OMIT,
        assignment: typing.Optional[CreateTicketRequestAssignment] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Jobs:
        """
        Enqueues ticket creation for asynchronous processing, returning if the job was enqueued successfully to be processed. We attempt to perform a best-effort validation on inputs before tasks are enqueued. If the given parameters are incorrect, we won't enqueue the job.

        Parameters
        ----------
        ticket_type_id : str
            The ID of the type of ticket you want to create

        contacts : typing.Sequence[CreateTicketRequestContactsItem]
            The list of contacts (users or leads) affected by this ticket. Currently only one is allowed

        skip_notifications : typing.Optional[bool]
            Option to disable notifications when a Ticket is created.

        conversation_to_link_id : typing.Optional[str]
            The ID of the conversation you want to link to the ticket. Here are the valid ways of linking two tickets:
             - conversation | back-office ticket
             - customer tickets | non-shared back-office ticket
             - conversation | tracker ticket
             - customer ticket | tracker ticket

        company_id : typing.Optional[str]
            The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom

        created_at : typing.Optional[int]
            The time the ticket was created. If not provided, the current time will be used.

        assignment : typing.Optional[CreateTicketRequestAssignment]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Jobs
            Successful response

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import CreateTicketRequestContactsItemId

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tickets.enqueue_create_ticket(
            ticket_type_id="1234",
            contacts=[
                CreateTicketRequestContactsItemId(
                    id="6762f2d81bb69f9f2193bc54",
                )
            ],
        )
        """
        _response = self._raw_client.enqueue_create_ticket(
            ticket_type_id=ticket_type_id,
            contacts=contacts,
            skip_notifications=skip_notifications,
            conversation_to_link_id=conversation_to_link_id,
            company_id=company_id,
            created_at=created_at,
            assignment=assignment,
            request_options=request_options,
        )
        return _response.data

    def get_ticket(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[Ticket]:
        """
        You can fetch the details of a single ticket.

        Parameters
        ----------
        id : str
            The unique identifier for the ticket which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Ticket]
            Ticket found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tickets.get_ticket(
            id="id",
        )
        """
        _response = self._raw_client.get_ticket(id, request_options=request_options)
        return _response.data

    def update_ticket(
        self,
        id: str,
        *,
        ticket_attributes: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ticket_state_id: typing.Optional[str] = OMIT,
        company_id: typing.Optional[str] = OMIT,
        open: typing.Optional[bool] = OMIT,
        is_shared: typing.Optional[bool] = OMIT,
        snoozed_until: typing.Optional[int] = OMIT,
        admin_id: typing.Optional[int] = OMIT,
        assignee_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[Ticket]:
        """
        You can update a ticket.

        Parameters
        ----------
        id : str
            The unique identifier for the ticket which is given by Intercom

        ticket_attributes : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The attributes set on the ticket.

        ticket_state_id : typing.Optional[str]
            The ID of the ticket state associated with the ticket type.

        company_id : typing.Optional[str]
            The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.

        open : typing.Optional[bool]
            Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.

        is_shared : typing.Optional[bool]
            Specify whether the ticket is visible to users.

        snoozed_until : typing.Optional[int]
            The time you want the ticket to reopen.

        admin_id : typing.Optional[int]
            The ID of the admin performing ticket update. Needed for workflows execution and attributing actions to specific admins.

        assignee_id : typing.Optional[str]
            The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Ticket]
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tickets.update_ticket(
            id="id",
            ticket_attributes={
                "_default_title_": "example",
                "_default_description_": "there is a problem",
            },
            ticket_state_id="123",
            open=True,
            snoozed_until=1673609604,
            admin_id=991268011,
            assignee_id="123",
        )
        """
        _response = self._raw_client.update_ticket(
            id,
            ticket_attributes=ticket_attributes,
            ticket_state_id=ticket_state_id,
            company_id=company_id,
            open=open,
            is_shared=is_shared,
            snoozed_until=snoozed_until,
            admin_id=admin_id,
            assignee_id=assignee_id,
            request_options=request_options,
        )
        return _response.data

    def delete_ticket(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteTicketResponse:
        """
        You can delete a ticket using the Intercom provided ID.

        Parameters
        ----------
        id : str
            The unique identifier for the ticket which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteTicketResponse
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tickets.delete_ticket(
            id="id",
        )
        """
        _response = self._raw_client.delete_ticket(id, request_options=request_options)
        return _response.data

    def search_tickets(
        self,
        *,
        query: SearchRequestQuery,
        pagination: typing.Optional[StartingAfterPaging] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketList:
        """
        You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.

        To search for tickets, you send a `POST` request to `https://api.intercom.io/tickets/search`.

        This will accept a query object in the body which will define your filters.
        {% admonition type="warning" name="Optimizing search queries" %}
          Search queries can be complex, so optimizing them can help the performance of your search.
          Use the `AND` and `OR` operators to combine multiple filters to get the exact results you need and utilize
          pagination to limit the number of results returned. The default is `20` results per page.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request) for more details on how to use the `starting_after` param.
        {% /admonition %}

        ### Nesting & Limitations

        You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
        There are some limitations to the amount of multiples there can be:
        - There's a limit of max 2 nested filters
        - There's a limit of max 15 filters for each AND or OR group

        ### Accepted Fields

        Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as `created_at` accepts a date, the `value` cannot be a string such as `"foobar"`).
        The `source.body` field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a `"I need support"` body - the query should contain a `=` operator with the value `"support"` for such conversation to be returned. A query with a `=` operator and a `"need support"` value will not yield a result.

        | Field                                     | Type                                                                                     |
        | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
        | id                                        | String                                                                                   |
        | created_at                                | Date (UNIX timestamp)                                                                    |
        | updated_at                                | Date (UNIX timestamp)                                                                    |
        | _default_title_                           | String                                                                                   |
        | _default_description_                     | String                                                                                   |
        | category                                  | String                                                                                   |
        | ticket_type_id                            | String                                                                                   |
        | contact_ids                               | String                                                                                   |
        | teammate_ids                              | String                                                                                   |
        | admin_assignee_id                         | String                                                                                   |
        | team_assignee_id                          | String                                                                                   |
        | open                                      | Boolean                                                                                  |
        | state                                     | String                                                                                   |
        | snoozed_until                             | Date (UNIX timestamp)                                                                    |
        | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |

        {% admonition type="info" name="Searching by Category" %}
        When searching for tickets by the **`category`** field, specific terms must be used instead of the category names:
        * For **Customer** category tickets, use the term `request`.
        * For **Back-office** category tickets, use the term `task`.
        * For **Tracker** category tickets, use the term `tracker`.
        {% /admonition %}

        ### Accepted Operators

        {% admonition type="info" name="Searching based on `created_at`" %}
          You may use the `<=` or `>=` operators to search by `created_at`.
        {% /admonition %}

        The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (`"="`). The operator has to be compatible with the field's type  (eg. you cannot search with `>` for a given string value as it's only compatible for integer's and dates).

        | Operator | Valid Types                    | Description                                                  |
        | :------- | :----------------------------- | :----------------------------------------------------------- |
        | =        | All                            | Equals                                                       |
        | !=       | All                            | Doesn't Equal                                                |
        | IN       | All                            | In  Shortcut for `OR` queries  Values most be in Array       |
        | NIN      | All                            | Not In  Shortcut for `OR !` queries  Values must be in Array |
        | >        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
        | <       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
        | ~        | String                         | Contains                                                     |
        | !~       | String                         | Doesn't Contain                                              |
        | ^        | String                         | Starts With                                                  |
        | $        | String                         | Ends With                                                    |

        Parameters
        ----------
        query : SearchRequestQuery

        pagination : typing.Optional[StartingAfterPaging]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketList
            successful

        Examples
        --------
        from intercom import Intercom
        from intercom.unstable import (
            MultipleFilterSearchRequest,
            SingleFilterSearchRequest,
            StartingAfterPaging,
        )

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.tickets.search_tickets(
            query=MultipleFilterSearchRequest(
                operator="AND",
                value=[
                    SingleFilterSearchRequest(
                        field="created_at",
                        operator=">",
                        value="1306054154",
                    )
                ],
            ),
            pagination=StartingAfterPaging(
                per_page=5,
            ),
        )
        """
        _response = self._raw_client.search_tickets(query=query, pagination=pagination, request_options=request_options)
        return _response.data


class AsyncTicketsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTicketsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTicketsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTicketsClient
        """
        return self._raw_client

    async def reply_ticket(
        self, id: str, *, request: ReplyTicketRequestBody, request_options: typing.Optional[RequestOptions] = None
    ) -> TicketReply:
        """
        You can reply to a ticket with a message from an admin or on behalf of a contact, or with a note for admins.

        Parameters
        ----------
        id : str

        request : ReplyTicketRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketReply
            Admin Reply to send Quick Reply Options

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import ContactReplyTicketIntercomUserIdRequest

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tickets.reply_ticket(
                id="123",
                request=ContactReplyTicketIntercomUserIdRequest(
                    body="Thanks again :)",
                    intercom_user_id="6762f2971bb69f9f2193bc49",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.reply_ticket(id, request=request, request_options=request_options)
        return _response.data

    async def enqueue_create_ticket(
        self,
        *,
        ticket_type_id: str,
        contacts: typing.Sequence[CreateTicketRequestContactsItem],
        skip_notifications: typing.Optional[bool] = OMIT,
        conversation_to_link_id: typing.Optional[str] = OMIT,
        company_id: typing.Optional[str] = OMIT,
        created_at: typing.Optional[int] = OMIT,
        assignment: typing.Optional[CreateTicketRequestAssignment] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Jobs:
        """
        Enqueues ticket creation for asynchronous processing, returning if the job was enqueued successfully to be processed. We attempt to perform a best-effort validation on inputs before tasks are enqueued. If the given parameters are incorrect, we won't enqueue the job.

        Parameters
        ----------
        ticket_type_id : str
            The ID of the type of ticket you want to create

        contacts : typing.Sequence[CreateTicketRequestContactsItem]
            The list of contacts (users or leads) affected by this ticket. Currently only one is allowed

        skip_notifications : typing.Optional[bool]
            Option to disable notifications when a Ticket is created.

        conversation_to_link_id : typing.Optional[str]
            The ID of the conversation you want to link to the ticket. Here are the valid ways of linking two tickets:
             - conversation | back-office ticket
             - customer tickets | non-shared back-office ticket
             - conversation | tracker ticket
             - customer ticket | tracker ticket

        company_id : typing.Optional[str]
            The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom

        created_at : typing.Optional[int]
            The time the ticket was created. If not provided, the current time will be used.

        assignment : typing.Optional[CreateTicketRequestAssignment]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Jobs
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import CreateTicketRequestContactsItemId

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tickets.enqueue_create_ticket(
                ticket_type_id="1234",
                contacts=[
                    CreateTicketRequestContactsItemId(
                        id="6762f2d81bb69f9f2193bc54",
                    )
                ],
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.enqueue_create_ticket(
            ticket_type_id=ticket_type_id,
            contacts=contacts,
            skip_notifications=skip_notifications,
            conversation_to_link_id=conversation_to_link_id,
            company_id=company_id,
            created_at=created_at,
            assignment=assignment,
            request_options=request_options,
        )
        return _response.data

    async def get_ticket(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[Ticket]:
        """
        You can fetch the details of a single ticket.

        Parameters
        ----------
        id : str
            The unique identifier for the ticket which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Ticket]
            Ticket found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tickets.get_ticket(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_ticket(id, request_options=request_options)
        return _response.data

    async def update_ticket(
        self,
        id: str,
        *,
        ticket_attributes: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        ticket_state_id: typing.Optional[str] = OMIT,
        company_id: typing.Optional[str] = OMIT,
        open: typing.Optional[bool] = OMIT,
        is_shared: typing.Optional[bool] = OMIT,
        snoozed_until: typing.Optional[int] = OMIT,
        admin_id: typing.Optional[int] = OMIT,
        assignee_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[Ticket]:
        """
        You can update a ticket.

        Parameters
        ----------
        id : str
            The unique identifier for the ticket which is given by Intercom

        ticket_attributes : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            The attributes set on the ticket.

        ticket_state_id : typing.Optional[str]
            The ID of the ticket state associated with the ticket type.

        company_id : typing.Optional[str]
            The ID of the company that the ticket is associated with. The unique identifier for the company which is given by Intercom. Set to nil to remove company.

        open : typing.Optional[bool]
            Specify if a ticket is open. Set to false to close a ticket. Closing a ticket will also unsnooze it.

        is_shared : typing.Optional[bool]
            Specify whether the ticket is visible to users.

        snoozed_until : typing.Optional[int]
            The time you want the ticket to reopen.

        admin_id : typing.Optional[int]
            The ID of the admin performing ticket update. Needed for workflows execution and attributing actions to specific admins.

        assignee_id : typing.Optional[str]
            The ID of the admin or team to which the ticket is assigned. Set this 0 to unassign it.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[Ticket]
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tickets.update_ticket(
                id="id",
                ticket_attributes={
                    "_default_title_": "example",
                    "_default_description_": "there is a problem",
                },
                ticket_state_id="123",
                open=True,
                snoozed_until=1673609604,
                admin_id=991268011,
                assignee_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_ticket(
            id,
            ticket_attributes=ticket_attributes,
            ticket_state_id=ticket_state_id,
            company_id=company_id,
            open=open,
            is_shared=is_shared,
            snoozed_until=snoozed_until,
            admin_id=admin_id,
            assignee_id=assignee_id,
            request_options=request_options,
        )
        return _response.data

    async def delete_ticket(
        self, id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeleteTicketResponse:
        """
        You can delete a ticket using the Intercom provided ID.

        Parameters
        ----------
        id : str
            The unique identifier for the ticket which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeleteTicketResponse
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tickets.delete_ticket(
                id="id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_ticket(id, request_options=request_options)
        return _response.data

    async def search_tickets(
        self,
        *,
        query: SearchRequestQuery,
        pagination: typing.Optional[StartingAfterPaging] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> TicketList:
        """
        You can search for multiple tickets by the value of their attributes in order to fetch exactly which ones you want.

        To search for tickets, you send a `POST` request to `https://api.intercom.io/tickets/search`.

        This will accept a query object in the body which will define your filters.
        {% admonition type="warning" name="Optimizing search queries" %}
          Search queries can be complex, so optimizing them can help the performance of your search.
          Use the `AND` and `OR` operators to combine multiple filters to get the exact results you need and utilize
          pagination to limit the number of results returned. The default is `20` results per page.
          See the [pagination section](https://developers.intercom.com/docs/build-an-integration/learn-more/rest-apis/pagination/#example-search-conversations-request) for more details on how to use the `starting_after` param.
        {% /admonition %}

        ### Nesting & Limitations

        You can nest these filters in order to get even more granular insights that pinpoint exactly what you need. Example: (1 OR 2) AND (3 OR 4).
        There are some limitations to the amount of multiples there can be:
        - There's a limit of max 2 nested filters
        - There's a limit of max 15 filters for each AND or OR group

        ### Accepted Fields

        Most keys listed as part of the Ticket model are searchable, whether writeable or not. The value you search for has to match the accepted type, otherwise the query will fail (ie. as `created_at` accepts a date, the `value` cannot be a string such as `"foobar"`).
        The `source.body` field is unique as the search will not be performed against the entire value, but instead against every element of the value separately. For example, when searching for a conversation with a `"I need support"` body - the query should contain a `=` operator with the value `"support"` for such conversation to be returned. A query with a `=` operator and a `"need support"` value will not yield a result.

        | Field                                     | Type                                                                                     |
        | :---------------------------------------- | :--------------------------------------------------------------------------------------- |
        | id                                        | String                                                                                   |
        | created_at                                | Date (UNIX timestamp)                                                                    |
        | updated_at                                | Date (UNIX timestamp)                                                                    |
        | _default_title_                           | String                                                                                   |
        | _default_description_                     | String                                                                                   |
        | category                                  | String                                                                                   |
        | ticket_type_id                            | String                                                                                   |
        | contact_ids                               | String                                                                                   |
        | teammate_ids                              | String                                                                                   |
        | admin_assignee_id                         | String                                                                                   |
        | team_assignee_id                          | String                                                                                   |
        | open                                      | Boolean                                                                                  |
        | state                                     | String                                                                                   |
        | snoozed_until                             | Date (UNIX timestamp)                                                                    |
        | ticket_attribute.{id}                     | String or Boolean or Date (UNIX timestamp) or Float or Integer                           |

        {% admonition type="info" name="Searching by Category" %}
        When searching for tickets by the **`category`** field, specific terms must be used instead of the category names:
        * For **Customer** category tickets, use the term `request`.
        * For **Back-office** category tickets, use the term `task`.
        * For **Tracker** category tickets, use the term `tracker`.
        {% /admonition %}

        ### Accepted Operators

        {% admonition type="info" name="Searching based on `created_at`" %}
          You may use the `<=` or `>=` operators to search by `created_at`.
        {% /admonition %}

        The table below shows the operators you can use to define how you want to search for the value.  The operator should be put in as a string (`"="`). The operator has to be compatible with the field's type  (eg. you cannot search with `>` for a given string value as it's only compatible for integer's and dates).

        | Operator | Valid Types                    | Description                                                  |
        | :------- | :----------------------------- | :----------------------------------------------------------- |
        | =        | All                            | Equals                                                       |
        | !=       | All                            | Doesn't Equal                                                |
        | IN       | All                            | In  Shortcut for `OR` queries  Values most be in Array       |
        | NIN      | All                            | Not In  Shortcut for `OR !` queries  Values must be in Array |
        | >        | Integer  Date (UNIX Timestamp) | Greater (or equal) than                                      |
        | <       | Integer  Date (UNIX Timestamp) | Lower (or equal) than                                        |
        | ~        | String                         | Contains                                                     |
        | !~       | String                         | Doesn't Contain                                              |
        | ^        | String                         | Starts With                                                  |
        | $        | String                         | Ends With                                                    |

        Parameters
        ----------
        query : SearchRequestQuery

        pagination : typing.Optional[StartingAfterPaging]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TicketList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom
        from intercom.unstable import (
            MultipleFilterSearchRequest,
            SingleFilterSearchRequest,
            StartingAfterPaging,
        )

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.tickets.search_tickets(
                query=MultipleFilterSearchRequest(
                    operator="AND",
                    value=[
                        SingleFilterSearchRequest(
                            field="created_at",
                            operator=">",
                            value="1306054154",
                        )
                    ],
                ),
                pagination=StartingAfterPaging(
                    per_page=5,
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search_tickets(
            query=query, pagination=pagination, request_options=request_options
        )
        return _response.data
