# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class ContactLocation(UncheckedBaseModel):
    """
    An object containing location meta data about a Intercom contact.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Always location
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    The country that the contact is located in
    """

    region: typing.Optional[str] = pydantic.Field(default=None)
    """
    The overal region that the contact is located in
    """

    city: typing.Optional[str] = pydantic.Field(default=None)
    """
    The city that the contact is located in
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
