# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class Translation(UncheckedBaseModel):
    """
    A translation object contains the localised details of a subscription type.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The localised name of the subscription type.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The localised description of the subscription type.
    """

    locale: typing.Optional[str] = pydantic.Field(default=None)
    """
    The two character identifier for the language of the translation object.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
