# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .visitor_avatar import VisitorAvatar
from .visitor_companies import VisitorCompanies
from .visitor_location_data import VisitorLocationData
from .visitor_segments import VisitorSegments
from .visitor_social_profiles import VisitorSocialProfiles
from .visitor_tags import VisitorTags


class Visitor(UncheckedBaseModel):
    """
    Visitors are useful for representing anonymous people that have not yet been identified. They usually represent website visitors. Visitors are not visible in Intercom platform. The Visitors resource provides methods to fetch, update, convert and delete.
    """

    type: typing.Optional[str] = pydantic.Field(default=None)
    """
    Value is 'visitor'
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The Intercom defined id representing the Visitor.
    """

    user_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Automatically generated identifier for the Visitor.
    """

    anonymous: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Identifies if this visitor is anonymous.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email of the visitor.
    """

    phone: typing.Optional[str] = pydantic.Field(default=None)
    """
    The phone number of the visitor.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the visitor.
    """

    pseudonym: typing.Optional[str] = pydantic.Field(default=None)
    """
    The pseudonym of the visitor.
    """

    avatar: typing.Optional[VisitorAvatar] = None
    app_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the app the visitor is associated with.
    """

    companies: typing.Optional[VisitorCompanies] = None
    location_data: typing.Optional[VisitorLocationData] = None
    las_request_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the Lead last recorded making a request.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the Visitor was added to Intercom.
    """

    remote_created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the Visitor was added to Intercom.
    """

    signed_up_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the Visitor signed up for your product.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the Visitor was updated.
    """

    session_count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of sessions the Visitor has had.
    """

    social_profiles: typing.Optional[VisitorSocialProfiles] = None
    owner_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the admin that owns the Visitor.
    """

    unsubscribed_from_emails: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the Visitor is unsubscribed from emails.
    """

    marked_email_as_spam: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Identifies if this visitor has marked an email as spam.
    """

    has_hard_bounced: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Identifies if this visitor has had a hard bounce.
    """

    tags: typing.Optional[VisitorTags] = None
    segments: typing.Optional[VisitorSegments] = None
    custom_attributes: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    The custom attributes you have set on the Visitor.
    """

    referrer: typing.Optional[str] = pydantic.Field(default=None)
    """
    The referer of the visitor.
    """

    utm_campaign: typing.Optional[str] = pydantic.Field(default=None)
    """
    The utm_campaign of the visitor.
    """

    utm_content: typing.Optional[str] = pydantic.Field(default=None)
    """
    The utm_content of the visitor.
    """

    utm_medium: typing.Optional[str] = pydantic.Field(default=None)
    """
    The utm_medium of the visitor.
    """

    utm_source: typing.Optional[str] = pydantic.Field(default=None)
    """
    The utm_source of the visitor.
    """

    utm_term: typing.Optional[str] = pydantic.Field(default=None)
    """
    The utm_term of the visitor.
    """

    do_not_track: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Identifies if this visitor has do not track enabled.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
