# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .whatsapp_message_status_list_events_item_status import WhatsappMessageStatusListEventsItemStatus


class WhatsappMessageStatusListEventsItem(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    Event ID
    """

    conversation_id: str = pydantic.Field()
    """
    ID of the conversation
    """

    status: WhatsappMessageStatusListEventsItemStatus = pydantic.Field()
    """
    Current status of the message
    """

    type: typing.Literal["broadcast_outbound"] = pydantic.Field(default="broadcast_outbound")
    """
    Event type
    """

    created_at: int = pydantic.Field()
    """
    Creation timestamp
    """

    updated_at: int = pydantic.Field()
    """
    Last update timestamp
    """

    whatsapp_message_id: str = pydantic.Field()
    """
    WhatsApp's message identifier
    """

    template_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the WhatsApp template used
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
