/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#comment ApiAuthenticationIntegrationWithAuthorizationCodeGrant#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether this security integration is enabled or disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#enabled ApiAuthenticationIntegrationWithAuthorizationCodeGrant#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#id ApiAuthenticationIntegrationWithAuthorizationCodeGrant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier (i.e. name) for the integration. This value must be unique in your account. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#name ApiAuthenticationIntegrationWithAuthorizationCodeGrant#name}
    */
    readonly name: string;
    /**
    * Specifies the default lifetime of the OAuth access token (in seconds) issued by an OAuth server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#oauth_access_token_validity ApiAuthenticationIntegrationWithAuthorizationCodeGrant#oauth_access_token_validity}
    */
    readonly oauthAccessTokenValidity?: number;
    /**
    * Specifies a list of scopes to use when making a request from the OAuth by a role with USAGE on the integration during the OAuth client credentials flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#oauth_allowed_scopes ApiAuthenticationIntegrationWithAuthorizationCodeGrant#oauth_allowed_scopes}
    */
    readonly oauthAllowedScopes?: string[];
    /**
    * Specifies the URL for authenticating to the external service. If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#oauth_authorization_endpoint ApiAuthenticationIntegrationWithAuthorizationCodeGrant#oauth_authorization_endpoint}
    */
    readonly oauthAuthorizationEndpoint?: string;
    /**
    * Specifies that POST is used as the authentication method to the external service. If removed from the config, the resource is recreated. Valid values are (case-insensitive): `CLIENT_SECRET_POST`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#oauth_client_auth_method ApiAuthenticationIntegrationWithAuthorizationCodeGrant#oauth_client_auth_method}
    */
    readonly oauthClientAuthMethod?: string;
    /**
    * Specifies the client ID for the OAuth application in the external service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#oauth_client_id ApiAuthenticationIntegrationWithAuthorizationCodeGrant#oauth_client_id}
    */
    readonly oauthClientId: string;
    /**
    * Specifies the client secret for the OAuth application in the ServiceNow instance from the previous step. The connector uses this to request an access token from the ServiceNow instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#oauth_client_secret ApiAuthenticationIntegrationWithAuthorizationCodeGrant#oauth_client_secret}
    */
    readonly oauthClientSecret: string;
    /**
    * Specifies the value to determine the validity of the refresh token obtained from the OAuth server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#oauth_refresh_token_validity ApiAuthenticationIntegrationWithAuthorizationCodeGrant#oauth_refresh_token_validity}
    */
    readonly oauthRefreshTokenValidity?: number;
    /**
    * Specifies the token endpoint used by the client to obtain an access token by presenting its authorization grant or refresh token. The token endpoint is used with every authorization grant except for the implicit grant type (since an access token is issued directly). If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#oauth_token_endpoint ApiAuthenticationIntegrationWithAuthorizationCodeGrant#oauth_token_endpoint}
    */
    readonly oauthTokenEndpoint?: string;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthType {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthTypeToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthType): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthTypeToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthType): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthType | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthType | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthTypeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthTypeOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputComment {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputCommentToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputComment): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputCommentToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputComment): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputCommentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputComment | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputComment | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputCommentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputCommentOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabled {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabledToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabled): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabledToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabled): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabled | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabled | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabledList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabledOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidity {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidityToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidity): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidityToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidity): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidity | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidity | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidityOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopes {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopesToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopes): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopesToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopes): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopes | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopes | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopesOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpoint {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpointToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpoint): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpointToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpoint): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpoint | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpointOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethod {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethodToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethod): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethodToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethod): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethod | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethod | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethodOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientId {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientIdToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientId): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientIdToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientId): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientId | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientId | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientIdOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrant {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrantToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrant): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrantToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrant): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrantOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrant | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrant | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrantList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrantOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidity {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidityToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidity): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidityToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidity): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidity | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidity | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidityOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpoint {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpointToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpoint): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpointToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpoint): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpoint | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpointOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegration {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegrationToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegration): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegrationToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegration): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegration | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegration | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegrationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegrationOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutput {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutput): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutput): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutput | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutput | undefined);
    private _authType;
    get authType(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputAuthTypeList;
    private _comment;
    get comment(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputCommentList;
    private _enabled;
    get enabled(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputEnabledList;
    private _oauthAccessTokenValidity;
    get oauthAccessTokenValidity(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAccessTokenValidityList;
    private _oauthAllowedScopes;
    get oauthAllowedScopes(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAllowedScopesList;
    private _oauthAuthorizationEndpoint;
    get oauthAuthorizationEndpoint(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthAuthorizationEndpointList;
    private _oauthClientAuthMethod;
    get oauthClientAuthMethod(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientAuthMethodList;
    private _oauthClientId;
    get oauthClientId(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthClientIdList;
    private _oauthGrant;
    get oauthGrant(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthGrantList;
    private _oauthRefreshTokenValidity;
    get oauthRefreshTokenValidity(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthRefreshTokenValidityList;
    private _oauthTokenEndpoint;
    get oauthTokenEndpoint(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOauthTokenEndpointList;
    private _parentIntegration;
    get parentIntegration(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputParentIntegrationList;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputOutputReference;
}
export interface ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutput {
}
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutputToTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutput): any;
export declare function apiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutputToHclTerraform(struct?: ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutput): any;
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutput | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutput | undefined);
    get category(): string;
    get comment(): string;
    get createdOn(): string;
    get enabled(): cdktf.IResolvable;
    get integrationType(): string;
    get name(): string;
}
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant snowflake_api_authentication_integration_with_authorization_code_grant}
*/
export declare class ApiAuthenticationIntegrationWithAuthorizationCodeGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_api_authentication_integration_with_authorization_code_grant";
    /**
    * Generates CDKTF code for importing a ApiAuthenticationIntegrationWithAuthorizationCodeGrant resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiAuthenticationIntegrationWithAuthorizationCodeGrant to import
    * @param importFromId The id of the existing ApiAuthenticationIntegrationWithAuthorizationCodeGrant that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiAuthenticationIntegrationWithAuthorizationCodeGrant to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_authorization_code_grant snowflake_api_authentication_integration_with_authorization_code_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiAuthenticationIntegrationWithAuthorizationCodeGrantConfig
    */
    constructor(scope: Construct, id: string, config: ApiAuthenticationIntegrationWithAuthorizationCodeGrantConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantDescribeOutputList;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oauthAccessTokenValidity?;
    get oauthAccessTokenValidity(): number;
    set oauthAccessTokenValidity(value: number);
    resetOauthAccessTokenValidity(): void;
    get oauthAccessTokenValidityInput(): number | undefined;
    private _oauthAllowedScopes?;
    get oauthAllowedScopes(): string[];
    set oauthAllowedScopes(value: string[]);
    resetOauthAllowedScopes(): void;
    get oauthAllowedScopesInput(): string[] | undefined;
    private _oauthAuthorizationEndpoint?;
    get oauthAuthorizationEndpoint(): string;
    set oauthAuthorizationEndpoint(value: string);
    resetOauthAuthorizationEndpoint(): void;
    get oauthAuthorizationEndpointInput(): string | undefined;
    private _oauthClientAuthMethod?;
    get oauthClientAuthMethod(): string;
    set oauthClientAuthMethod(value: string);
    resetOauthClientAuthMethod(): void;
    get oauthClientAuthMethodInput(): string | undefined;
    private _oauthClientId?;
    get oauthClientId(): string;
    set oauthClientId(value: string);
    get oauthClientIdInput(): string | undefined;
    private _oauthClientSecret?;
    get oauthClientSecret(): string;
    set oauthClientSecret(value: string);
    get oauthClientSecretInput(): string | undefined;
    private _oauthRefreshTokenValidity?;
    get oauthRefreshTokenValidity(): number;
    set oauthRefreshTokenValidity(value: number);
    resetOauthRefreshTokenValidity(): void;
    get oauthRefreshTokenValidityInput(): number | undefined;
    private _oauthTokenEndpoint?;
    get oauthTokenEndpoint(): string;
    set oauthTokenEndpoint(value: string);
    resetOauthTokenEndpoint(): void;
    get oauthTokenEndpointInput(): string | undefined;
    private _showOutput;
    get showOutput(): ApiAuthenticationIntegrationWithAuthorizationCodeGrantShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
