/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiAuthenticationIntegrationWithClientCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#comment ApiAuthenticationIntegrationWithClientCredentials#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether this security integration is enabled or disabled.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#enabled ApiAuthenticationIntegrationWithClientCredentials#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#id ApiAuthenticationIntegrationWithClientCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the identifier (i.e. name) for the integration. This value must be unique in your account. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#name ApiAuthenticationIntegrationWithClientCredentials#name}
    */
    readonly name: string;
    /**
    * Specifies the default lifetime of the OAuth access token (in seconds) issued by an OAuth server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#oauth_access_token_validity ApiAuthenticationIntegrationWithClientCredentials#oauth_access_token_validity}
    */
    readonly oauthAccessTokenValidity?: number;
    /**
    * Specifies a list of scopes to use when making a request from the OAuth by a role with USAGE on the integration during the OAuth client credentials flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#oauth_allowed_scopes ApiAuthenticationIntegrationWithClientCredentials#oauth_allowed_scopes}
    */
    readonly oauthAllowedScopes?: string[];
    /**
    * Specifies that POST is used as the authentication method to the external service. If removed from the config, the resource is recreated. Valid values are (case-insensitive): `CLIENT_SECRET_POST`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#oauth_client_auth_method ApiAuthenticationIntegrationWithClientCredentials#oauth_client_auth_method}
    */
    readonly oauthClientAuthMethod?: string;
    /**
    * Specifies the client ID for the OAuth application in the external service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#oauth_client_id ApiAuthenticationIntegrationWithClientCredentials#oauth_client_id}
    */
    readonly oauthClientId: string;
    /**
    * Specifies the client secret for the OAuth application in the ServiceNow instance from the previous step. The connector uses this to request an access token from the ServiceNow instance.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#oauth_client_secret ApiAuthenticationIntegrationWithClientCredentials#oauth_client_secret}
    */
    readonly oauthClientSecret: string;
    /**
    * Specifies the value to determine the validity of the refresh token obtained from the OAuth server.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#oauth_refresh_token_validity ApiAuthenticationIntegrationWithClientCredentials#oauth_refresh_token_validity}
    */
    readonly oauthRefreshTokenValidity?: number;
    /**
    * Specifies the token endpoint used by the client to obtain an access token by presenting its authorization grant or refresh token. The token endpoint is used with every authorization grant except for the implicit grant type (since an access token is issued directly). If removed from the config, the resource is recreated.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#oauth_token_endpoint ApiAuthenticationIntegrationWithClientCredentials#oauth_token_endpoint}
    */
    readonly oauthTokenEndpoint?: string;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthType {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthTypeToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthType): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthTypeToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthType): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthType | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthType | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthTypeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthTypeOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputComment {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputCommentToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputComment): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputCommentToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputComment): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputCommentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputComment | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputComment | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputCommentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputCommentOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabled {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabledToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabled): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabledToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabled): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabled | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabled | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabledList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabledOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidity {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidityToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidity): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidityToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidity): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidity | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidity | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidityOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopes {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopesToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopes): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopesToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopes): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopes | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopes | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopesOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpoint {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpointToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpoint): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpointToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpoint): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpoint | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpointOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethod {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethodToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethod): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethodToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethod): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethodOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethod | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethod | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethodList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethodOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientId {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientIdToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientId): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientIdToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientId): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientId | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientId | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientIdOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrant {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrantToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrant): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrantToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrant): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrantOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrant | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrant | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrantList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrantOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidity {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidityToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidity): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidityToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidity): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidity | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidity | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidityOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpoint {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpointToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpoint): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpointToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpoint): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpoint | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpointOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegration {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegrationToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegration): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegrationToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegration): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegrationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegration | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegration | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegrationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegrationOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsDescribeOutput {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutput): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsDescribeOutputToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutput): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutput | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsDescribeOutput | undefined);
    private _authType;
    get authType(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputAuthTypeList;
    private _comment;
    get comment(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputCommentList;
    private _enabled;
    get enabled(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputEnabledList;
    private _oauthAccessTokenValidity;
    get oauthAccessTokenValidity(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAccessTokenValidityList;
    private _oauthAllowedScopes;
    get oauthAllowedScopes(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAllowedScopesList;
    private _oauthAuthorizationEndpoint;
    get oauthAuthorizationEndpoint(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthAuthorizationEndpointList;
    private _oauthClientAuthMethod;
    get oauthClientAuthMethod(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientAuthMethodList;
    private _oauthClientId;
    get oauthClientId(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthClientIdList;
    private _oauthGrant;
    get oauthGrant(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthGrantList;
    private _oauthRefreshTokenValidity;
    get oauthRefreshTokenValidity(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthRefreshTokenValidityList;
    private _oauthTokenEndpoint;
    get oauthTokenEndpoint(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOauthTokenEndpointList;
    private _parentIntegration;
    get parentIntegration(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputParentIntegrationList;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputOutputReference;
}
export interface ApiAuthenticationIntegrationWithClientCredentialsShowOutput {
}
export declare function apiAuthenticationIntegrationWithClientCredentialsShowOutputToTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsShowOutput): any;
export declare function apiAuthenticationIntegrationWithClientCredentialsShowOutputToHclTerraform(struct?: ApiAuthenticationIntegrationWithClientCredentialsShowOutput): any;
export declare class ApiAuthenticationIntegrationWithClientCredentialsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ApiAuthenticationIntegrationWithClientCredentialsShowOutput | undefined;
    set internalValue(value: ApiAuthenticationIntegrationWithClientCredentialsShowOutput | undefined);
    get category(): string;
    get comment(): string;
    get createdOn(): string;
    get enabled(): cdktf.IResolvable;
    get integrationType(): string;
    get name(): string;
}
export declare class ApiAuthenticationIntegrationWithClientCredentialsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ApiAuthenticationIntegrationWithClientCredentialsShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials snowflake_api_authentication_integration_with_client_credentials}
*/
export declare class ApiAuthenticationIntegrationWithClientCredentials extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_api_authentication_integration_with_client_credentials";
    /**
    * Generates CDKTF code for importing a ApiAuthenticationIntegrationWithClientCredentials resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ApiAuthenticationIntegrationWithClientCredentials to import
    * @param importFromId The id of the existing ApiAuthenticationIntegrationWithClientCredentials that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ApiAuthenticationIntegrationWithClientCredentials to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/api_authentication_integration_with_client_credentials snowflake_api_authentication_integration_with_client_credentials} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiAuthenticationIntegrationWithClientCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: ApiAuthenticationIntegrationWithClientCredentialsConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ApiAuthenticationIntegrationWithClientCredentialsDescribeOutputList;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oauthAccessTokenValidity?;
    get oauthAccessTokenValidity(): number;
    set oauthAccessTokenValidity(value: number);
    resetOauthAccessTokenValidity(): void;
    get oauthAccessTokenValidityInput(): number | undefined;
    private _oauthAllowedScopes?;
    get oauthAllowedScopes(): string[];
    set oauthAllowedScopes(value: string[]);
    resetOauthAllowedScopes(): void;
    get oauthAllowedScopesInput(): string[] | undefined;
    private _oauthClientAuthMethod?;
    get oauthClientAuthMethod(): string;
    set oauthClientAuthMethod(value: string);
    resetOauthClientAuthMethod(): void;
    get oauthClientAuthMethodInput(): string | undefined;
    private _oauthClientId?;
    get oauthClientId(): string;
    set oauthClientId(value: string);
    get oauthClientIdInput(): string | undefined;
    private _oauthClientSecret?;
    get oauthClientSecret(): string;
    set oauthClientSecret(value: string);
    get oauthClientSecretInput(): string | undefined;
    private _oauthRefreshTokenValidity?;
    get oauthRefreshTokenValidity(): number;
    set oauthRefreshTokenValidity(value: number);
    resetOauthRefreshTokenValidity(): void;
    get oauthRefreshTokenValidityInput(): number | undefined;
    private _oauthTokenEndpoint?;
    get oauthTokenEndpoint(): string;
    set oauthTokenEndpoint(value: string);
    resetOauthTokenEndpoint(): void;
    get oauthTokenEndpointInput(): string | undefined;
    private _showOutput;
    get showOutput(): ApiAuthenticationIntegrationWithClientCredentialsShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
