/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeDatabasesConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#id DataSnowflakeDatabases#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#like DataSnowflakeDatabases#like}
    */
    readonly like?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#starts_with DataSnowflakeDatabases#starts_with}
    */
    readonly startsWith?: string;
    /**
    * Runs DESC DATABASE for each database returned by SHOW DATABASES. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#with_describe DataSnowflakeDatabases#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * Runs SHOW PARAMETERS FOR DATABASE for each database returned by SHOW DATABASES. The output of describe is saved to the parameters field as a map. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#with_parameters DataSnowflakeDatabases#with_parameters}
    */
    readonly withParameters?: boolean | cdktf.IResolvable;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#limit DataSnowflakeDatabases#limit}
    */
    readonly limit?: DataSnowflakeDatabasesLimit;
}
export interface DataSnowflakeDatabasesDatabasesDescribeOutput {
}
export declare function dataSnowflakeDatabasesDatabasesDescribeOutputToTerraform(struct?: DataSnowflakeDatabasesDatabasesDescribeOutput): any;
export declare function dataSnowflakeDatabasesDatabasesDescribeOutputToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesDescribeOutput): any;
export declare class DataSnowflakeDatabasesDatabasesDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesDescribeOutput | undefined);
    get createdOn(): string;
    get kind(): string;
    get name(): string;
}
export declare class DataSnowflakeDatabasesDatabasesDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesDescribeOutputOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersCatalog {
}
export declare function dataSnowflakeDatabasesDatabasesParametersCatalogToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersCatalog): any;
export declare function dataSnowflakeDatabasesDatabasesParametersCatalogToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersCatalog): any;
export declare class DataSnowflakeDatabasesDatabasesParametersCatalogOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersCatalog | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersCatalog | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersCatalogList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersCatalogOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDays {
}
export declare function dataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDaysToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDays): any;
export declare function dataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDaysToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDays): any;
export declare class DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDaysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDays | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDays | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDaysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDaysOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollation {
}
export declare function dataSnowflakeDatabasesDatabasesParametersDefaultDdlCollationToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollation): any;
export declare function dataSnowflakeDatabasesDatabasesParametersDefaultDdlCollationToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollation): any;
export declare class DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollation | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollation | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollationOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutput {
}
export declare function dataSnowflakeDatabasesDatabasesParametersEnableConsoleOutputToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutput): any;
export declare function dataSnowflakeDatabasesDatabasesParametersEnableConsoleOutputToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutput): any;
export declare class DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutput | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutputOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersExternalVolume {
}
export declare function dataSnowflakeDatabasesDatabasesParametersExternalVolumeToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersExternalVolume): any;
export declare function dataSnowflakeDatabasesDatabasesParametersExternalVolumeToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersExternalVolume): any;
export declare class DataSnowflakeDatabasesDatabasesParametersExternalVolumeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersExternalVolume | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersExternalVolume | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersExternalVolumeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersExternalVolumeOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersLogLevel {
}
export declare function dataSnowflakeDatabasesDatabasesParametersLogLevelToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersLogLevel): any;
export declare function dataSnowflakeDatabasesDatabasesParametersLogLevelToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersLogLevel): any;
export declare class DataSnowflakeDatabasesDatabasesParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersLogLevel | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersLogLevelOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDays {
}
export declare function dataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDaysToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDays): any;
export declare function dataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDaysToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDays): any;
export declare class DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDaysOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDays | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDays | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDaysList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDaysOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCase {
}
export declare function dataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCase): any;
export declare function dataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCase): any;
export declare class DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharacters {
}
export declare function dataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharactersToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharacters): any;
export declare function dataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharactersToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharacters): any;
export declare class DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharactersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharacters | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharacters | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharactersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharactersOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicy {
}
export declare function dataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicyToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicy): any;
export declare function dataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicyToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicy): any;
export declare class DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicy | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicyOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailures {
}
export declare function dataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailuresToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailures): any;
export declare function dataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailuresToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailures): any;
export declare class DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailuresOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailures | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailures | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailuresList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailuresOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttempts {
}
export declare function dataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttemptsToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttempts): any;
export declare function dataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttemptsToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttempts): any;
export declare class DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttemptsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttempts | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttempts | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttemptsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttemptsOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersTraceLevel {
}
export declare function dataSnowflakeDatabasesDatabasesParametersTraceLevelToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersTraceLevel): any;
export declare function dataSnowflakeDatabasesDatabasesParametersTraceLevelToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersTraceLevel): any;
export declare class DataSnowflakeDatabasesDatabasesParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersTraceLevel | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersTraceLevelOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSize {
}
export declare function dataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSizeToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSize): any;
export declare function dataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSizeToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSize): any;
export declare class DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSize | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSizeOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSeconds {
}
export declare function dataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSecondsToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare function dataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSecondsToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSeconds): any;
export declare class DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSeconds | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSecondsOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMs {
}
export declare function dataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMsToTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMs): any;
export declare function dataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMsToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMs): any;
export declare class DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMs | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMs | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMsOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesParameters {
}
export declare function dataSnowflakeDatabasesDatabasesParametersToTerraform(struct?: DataSnowflakeDatabasesDatabasesParameters): any;
export declare function dataSnowflakeDatabasesDatabasesParametersToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesParameters): any;
export declare class DataSnowflakeDatabasesDatabasesParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesParameters | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesParameters | undefined);
    private _catalog;
    get catalog(): DataSnowflakeDatabasesDatabasesParametersCatalogList;
    private _dataRetentionTimeInDays;
    get dataRetentionTimeInDays(): DataSnowflakeDatabasesDatabasesParametersDataRetentionTimeInDaysList;
    private _defaultDdlCollation;
    get defaultDdlCollation(): DataSnowflakeDatabasesDatabasesParametersDefaultDdlCollationList;
    private _enableConsoleOutput;
    get enableConsoleOutput(): DataSnowflakeDatabasesDatabasesParametersEnableConsoleOutputList;
    private _externalVolume;
    get externalVolume(): DataSnowflakeDatabasesDatabasesParametersExternalVolumeList;
    private _logLevel;
    get logLevel(): DataSnowflakeDatabasesDatabasesParametersLogLevelList;
    private _maxDataExtensionTimeInDays;
    get maxDataExtensionTimeInDays(): DataSnowflakeDatabasesDatabasesParametersMaxDataExtensionTimeInDaysList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): DataSnowflakeDatabasesDatabasesParametersQuotedIdentifiersIgnoreCaseList;
    private _replaceInvalidCharacters;
    get replaceInvalidCharacters(): DataSnowflakeDatabasesDatabasesParametersReplaceInvalidCharactersList;
    private _storageSerializationPolicy;
    get storageSerializationPolicy(): DataSnowflakeDatabasesDatabasesParametersStorageSerializationPolicyList;
    private _suspendTaskAfterNumFailures;
    get suspendTaskAfterNumFailures(): DataSnowflakeDatabasesDatabasesParametersSuspendTaskAfterNumFailuresList;
    private _taskAutoRetryAttempts;
    get taskAutoRetryAttempts(): DataSnowflakeDatabasesDatabasesParametersTaskAutoRetryAttemptsList;
    private _traceLevel;
    get traceLevel(): DataSnowflakeDatabasesDatabasesParametersTraceLevelList;
    private _userTaskManagedInitialWarehouseSize;
    get userTaskManagedInitialWarehouseSize(): DataSnowflakeDatabasesDatabasesParametersUserTaskManagedInitialWarehouseSizeList;
    private _userTaskMinimumTriggerIntervalInSeconds;
    get userTaskMinimumTriggerIntervalInSeconds(): DataSnowflakeDatabasesDatabasesParametersUserTaskMinimumTriggerIntervalInSecondsList;
    private _userTaskTimeoutMs;
    get userTaskTimeoutMs(): DataSnowflakeDatabasesDatabasesParametersUserTaskTimeoutMsList;
}
export declare class DataSnowflakeDatabasesDatabasesParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesParametersOutputReference;
}
export interface DataSnowflakeDatabasesDatabasesShowOutput {
}
export declare function dataSnowflakeDatabasesDatabasesShowOutputToTerraform(struct?: DataSnowflakeDatabasesDatabasesShowOutput): any;
export declare function dataSnowflakeDatabasesDatabasesShowOutputToHclTerraform(struct?: DataSnowflakeDatabasesDatabasesShowOutput): any;
export declare class DataSnowflakeDatabasesDatabasesShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabasesShowOutput | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabasesShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get droppedOn(): string;
    get isCurrent(): cdktf.IResolvable;
    get isDefault(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get options(): string;
    get origin(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get resourceGroup(): string;
    get retentionTime(): number;
    get transient(): cdktf.IResolvable;
}
export declare class DataSnowflakeDatabasesDatabasesShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesShowOutputOutputReference;
}
export interface DataSnowflakeDatabasesDatabases {
}
export declare function dataSnowflakeDatabasesDatabasesToTerraform(struct?: DataSnowflakeDatabasesDatabases): any;
export declare function dataSnowflakeDatabasesDatabasesToHclTerraform(struct?: DataSnowflakeDatabasesDatabases): any;
export declare class DataSnowflakeDatabasesDatabasesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeDatabasesDatabases | undefined;
    set internalValue(value: DataSnowflakeDatabasesDatabases | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeDatabasesDatabasesDescribeOutputList;
    private _parameters;
    get parameters(): DataSnowflakeDatabasesDatabasesParametersList;
    private _showOutput;
    get showOutput(): DataSnowflakeDatabasesDatabasesShowOutputList;
}
export declare class DataSnowflakeDatabasesDatabasesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeDatabasesDatabasesOutputReference;
}
export interface DataSnowflakeDatabasesLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#from DataSnowflakeDatabases#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#rows DataSnowflakeDatabases#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeDatabasesLimitToTerraform(struct?: DataSnowflakeDatabasesLimitOutputReference | DataSnowflakeDatabasesLimit): any;
export declare function dataSnowflakeDatabasesLimitToHclTerraform(struct?: DataSnowflakeDatabasesLimitOutputReference | DataSnowflakeDatabasesLimit): any;
export declare class DataSnowflakeDatabasesLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeDatabasesLimit | undefined;
    set internalValue(value: DataSnowflakeDatabasesLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases snowflake_databases}
*/
export declare class DataSnowflakeDatabases extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_databases";
    /**
    * Generates CDKTF code for importing a DataSnowflakeDatabases resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeDatabases to import
    * @param importFromId The id of the existing DataSnowflakeDatabases that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeDatabases to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/databases snowflake_databases} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeDatabasesConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeDatabasesConfig);
    private _databases;
    get databases(): DataSnowflakeDatabasesDatabasesList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _withParameters?;
    get withParameters(): boolean | cdktf.IResolvable;
    set withParameters(value: boolean | cdktf.IResolvable);
    resetWithParameters(): void;
    get withParametersInput(): boolean | cdktf.IResolvable | undefined;
    private _limit;
    get limit(): DataSnowflakeDatabasesLimitOutputReference;
    putLimit(value: DataSnowflakeDatabasesLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeDatabasesLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
