/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataSnowflakeViewsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#id DataSnowflakeViews#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Filters the output with **case-insensitive** pattern, with support for SQL wildcard characters (`%` and `_`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#like DataSnowflakeViews#like}
    */
    readonly like?: string;
    /**
    * Filters the output with **case-sensitive** characters indicating the beginning of the object name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#starts_with DataSnowflakeViews#starts_with}
    */
    readonly startsWith?: string;
    /**
    * Runs DESC VIEW for each view returned by SHOW VIEWS. The output of describe is saved to the description field. By default this value is set to true.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#with_describe DataSnowflakeViews#with_describe}
    */
    readonly withDescribe?: boolean | cdktf.IResolvable;
    /**
    * in block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#in DataSnowflakeViews#in}
    */
    readonly in?: DataSnowflakeViewsIn;
    /**
    * limit block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#limit DataSnowflakeViews#limit}
    */
    readonly limit?: DataSnowflakeViewsLimit;
}
export interface DataSnowflakeViewsViewsDescribeOutput {
}
export declare function dataSnowflakeViewsViewsDescribeOutputToTerraform(struct?: DataSnowflakeViewsViewsDescribeOutput): any;
export declare function dataSnowflakeViewsViewsDescribeOutputToHclTerraform(struct?: DataSnowflakeViewsViewsDescribeOutput): any;
export declare class DataSnowflakeViewsViewsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeViewsViewsDescribeOutput | undefined;
    set internalValue(value: DataSnowflakeViewsViewsDescribeOutput | undefined);
    get check(): string;
    get comment(): string;
    get default(): string;
    get expression(): string;
    get isNullable(): cdktf.IResolvable;
    get isPrimary(): cdktf.IResolvable;
    get isUnique(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get policyName(): string;
    get privacyDomain(): string;
    get type(): string;
}
export declare class DataSnowflakeViewsViewsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeViewsViewsDescribeOutputOutputReference;
}
export interface DataSnowflakeViewsViewsShowOutput {
}
export declare function dataSnowflakeViewsViewsShowOutputToTerraform(struct?: DataSnowflakeViewsViewsShowOutput): any;
export declare function dataSnowflakeViewsViewsShowOutputToHclTerraform(struct?: DataSnowflakeViewsViewsShowOutput): any;
export declare class DataSnowflakeViewsViewsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeViewsViewsShowOutput | undefined;
    set internalValue(value: DataSnowflakeViewsViewsShowOutput | undefined);
    get changeTracking(): string;
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get isMaterialized(): cdktf.IResolvable;
    get isSecure(): cdktf.IResolvable;
    get kind(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get reserved(): string;
    get schemaName(): string;
    get text(): string;
}
export declare class DataSnowflakeViewsViewsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeViewsViewsShowOutputOutputReference;
}
export interface DataSnowflakeViewsViews {
}
export declare function dataSnowflakeViewsViewsToTerraform(struct?: DataSnowflakeViewsViews): any;
export declare function dataSnowflakeViewsViewsToHclTerraform(struct?: DataSnowflakeViewsViews): any;
export declare class DataSnowflakeViewsViewsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataSnowflakeViewsViews | undefined;
    set internalValue(value: DataSnowflakeViewsViews | undefined);
    private _describeOutput;
    get describeOutput(): DataSnowflakeViewsViewsDescribeOutputList;
    private _showOutput;
    get showOutput(): DataSnowflakeViewsViewsShowOutputList;
}
export declare class DataSnowflakeViewsViewsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataSnowflakeViewsViewsOutputReference;
}
export interface DataSnowflakeViewsIn {
    /**
    * Returns records for the entire account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#account DataSnowflakeViews#account}
    */
    readonly account?: boolean | cdktf.IResolvable;
    /**
    * Returns records for the current database in use or for a specified database.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#database DataSnowflakeViews#database}
    */
    readonly database?: string;
    /**
    * Returns records for the current schema in use or a specified schema. Use fully qualified name.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#schema DataSnowflakeViews#schema}
    */
    readonly schema?: string;
}
export declare function dataSnowflakeViewsInToTerraform(struct?: DataSnowflakeViewsInOutputReference | DataSnowflakeViewsIn): any;
export declare function dataSnowflakeViewsInToHclTerraform(struct?: DataSnowflakeViewsInOutputReference | DataSnowflakeViewsIn): any;
export declare class DataSnowflakeViewsInOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeViewsIn | undefined;
    set internalValue(value: DataSnowflakeViewsIn | undefined);
    private _account?;
    get account(): boolean | cdktf.IResolvable;
    set account(value: boolean | cdktf.IResolvable);
    resetAccount(): void;
    get accountInput(): boolean | cdktf.IResolvable | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    resetDatabase(): void;
    get databaseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
}
export interface DataSnowflakeViewsLimit {
    /**
    * Specifies a **case-sensitive** pattern that is used to match object name. After the first match, the limit on the number of rows will be applied.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#from DataSnowflakeViews#from}
    */
    readonly from?: string;
    /**
    * The maximum number of rows to return.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#rows DataSnowflakeViews#rows}
    */
    readonly rows: number;
}
export declare function dataSnowflakeViewsLimitToTerraform(struct?: DataSnowflakeViewsLimitOutputReference | DataSnowflakeViewsLimit): any;
export declare function dataSnowflakeViewsLimitToHclTerraform(struct?: DataSnowflakeViewsLimitOutputReference | DataSnowflakeViewsLimit): any;
export declare class DataSnowflakeViewsLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataSnowflakeViewsLimit | undefined;
    set internalValue(value: DataSnowflakeViewsLimit | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    resetFrom(): void;
    get fromInput(): string | undefined;
    private _rows?;
    get rows(): number;
    set rows(value: number);
    get rowsInput(): number | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views snowflake_views}
*/
export declare class DataSnowflakeViews extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "snowflake_views";
    /**
    * Generates CDKTF code for importing a DataSnowflakeViews resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataSnowflakeViews to import
    * @param importFromId The id of the existing DataSnowflakeViews that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataSnowflakeViews to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/data-sources/views snowflake_views} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataSnowflakeViewsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataSnowflakeViewsConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _like?;
    get like(): string;
    set like(value: string);
    resetLike(): void;
    get likeInput(): string | undefined;
    private _startsWith?;
    get startsWith(): string;
    set startsWith(value: string);
    resetStartsWith(): void;
    get startsWithInput(): string | undefined;
    private _views;
    get views(): DataSnowflakeViewsViewsList;
    private _withDescribe?;
    get withDescribe(): boolean | cdktf.IResolvable;
    set withDescribe(value: boolean | cdktf.IResolvable);
    resetWithDescribe(): void;
    get withDescribeInput(): boolean | cdktf.IResolvable | undefined;
    private _in;
    get in(): DataSnowflakeViewsInOutputReference;
    putIn(value: DataSnowflakeViewsIn): void;
    resetIn(): void;
    get inInput(): DataSnowflakeViewsIn | undefined;
    private _limit;
    get limit(): DataSnowflakeViewsLimitOutputReference;
    putLimit(value: DataSnowflakeViewsLimit): void;
    resetLimit(): void;
    get limitInput(): DataSnowflakeViewsLimit | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
