/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface OauthIntegrationForCustomClientsConfig extends cdktf.TerraformMetaArguments {
    /**
    * A set of Snowflake roles that a user cannot explicitly consent to using after authenticating.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#blocked_roles_list OauthIntegrationForCustomClients#blocked_roles_list}
    */
    readonly blockedRolesList: string[];
    /**
    * Specifies a comment for the OAuth integration.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#comment OauthIntegrationForCustomClients#comment}
    */
    readonly comment?: string;
    /**
    * Specifies whether this OAuth integration is enabled or disabled. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#enabled OauthIntegrationForCustomClients#enabled}
    */
    readonly enabled?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#id OauthIntegrationForCustomClients#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the name of the OAuth integration. This name follows the rules for Object Identifiers. The name should be unique among security integrations in your account. Due to technical limitations (read more [here](https://github.com/Snowflake-Labs/terraform-provider-snowflake/blob/main/docs/technical-documentation/identifiers_rework_design_decisions.md#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `(`, `)`, `"`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#name OauthIntegrationForCustomClients#name}
    */
    readonly name: string;
    /**
    * Specifies an existing network policy. This network policy controls network traffic that is attempting to exchange an authorization code for an access or refresh token or to use a refresh token to obtain a new access token.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#network_policy OauthIntegrationForCustomClients#network_policy}
    */
    readonly networkPolicy?: string;
    /**
    * If true, allows setting oauth_redirect_uri to a URI not protected by TLS. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_allow_non_tls_redirect_uri OauthIntegrationForCustomClients#oauth_allow_non_tls_redirect_uri}
    */
    readonly oauthAllowNonTlsRedirectUri?: string;
    /**
    * Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource using `terraform taint`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_client_rsa_public_key OauthIntegrationForCustomClients#oauth_client_rsa_public_key}
    */
    readonly oauthClientRsaPublicKey?: string;
    /**
    * Specifies a Base64-encoded RSA public key, without the -----BEGIN PUBLIC KEY----- and -----END PUBLIC KEY----- headers. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource using `terraform taint`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_client_rsa_public_key_2 OauthIntegrationForCustomClients#oauth_client_rsa_public_key_2}
    */
    readonly oauthClientRsaPublicKey2?: string;
    /**
    * Specifies the type of client being registered. Snowflake supports both confidential and public clients. Valid options are: `PUBLIC` | `CONFIDENTIAL`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_client_type OauthIntegrationForCustomClients#oauth_client_type}
    */
    readonly oauthClientType: string;
    /**
    * Boolean that specifies whether Proof Key for Code Exchange (PKCE) should be required for the integration. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_enforce_pkce OauthIntegrationForCustomClients#oauth_enforce_pkce}
    */
    readonly oauthEnforcePkce?: string;
    /**
    * Specifies whether to allow the client to exchange a refresh token for an access token when the current access token has expired. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_issue_refresh_tokens OauthIntegrationForCustomClients#oauth_issue_refresh_tokens}
    */
    readonly oauthIssueRefreshTokens?: string;
    /**
    * Specifies the client URI. After a user is authenticated, the web browser is redirected to this URI.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_redirect_uri OauthIntegrationForCustomClients#oauth_redirect_uri}
    */
    readonly oauthRedirectUri: string;
    /**
    * Specifies how long refresh tokens should be valid (in seconds). OAUTH_ISSUE_REFRESH_TOKENS must be set to TRUE.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_refresh_token_validity OauthIntegrationForCustomClients#oauth_refresh_token_validity}
    */
    readonly oauthRefreshTokenValidity?: number;
    /**
    * Specifies whether default secondary roles set in the user properties are activated by default in the session being opened. Valid options are: `IMPLICIT` | `NONE`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#oauth_use_secondary_roles OauthIntegrationForCustomClients#oauth_use_secondary_roles}
    */
    readonly oauthUseSecondaryRoles?: string;
    /**
    * A set of Snowflake roles that a user does not need to explicitly consent to using after authenticating.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#pre_authorized_roles_list OauthIntegrationForCustomClients#pre_authorized_roles_list}
    */
    readonly preAuthorizedRolesList?: string[];
}
export interface OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStruct {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStructToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStruct): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStructToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStruct): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStruct | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStruct | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStructOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputComment {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputCommentToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputComment): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputCommentToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputComment): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputCommentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputComment | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputComment | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputCommentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputCommentOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputEnabled {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputEnabledToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputEnabled): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputEnabledToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputEnabled): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputEnabledOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputEnabled | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputEnabled | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputEnabledList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputEnabledOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputNetworkPolicy {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputNetworkPolicyToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputNetworkPolicy): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputNetworkPolicyToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputNetworkPolicy): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputNetworkPolicy | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputNetworkPolicy | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputNetworkPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputNetworkPolicyOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUri {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUriToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUri): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUriToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUri): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUriOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUri | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUri | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUriList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUriOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpoints {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpointsToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpoints): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpointsToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpoints): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpoints | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpoints | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpointsOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpoints {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpointsToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpoints): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpointsToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpoints): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpointsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpoints | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpoints | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpointsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpointsOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpoint {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpointToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpoint): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpointToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpoint): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpoint | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpointOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthClientId {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthClientIdToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthClientId): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthClientIdToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthClientId): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthClientIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthClientId | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthClientId | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthClientIdList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthClientIdOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2Fp {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2FpToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2Fp): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2FpToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2Fp): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2FpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2Fp | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2Fp | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2FpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2FpOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFp {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFpToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFp): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFpToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFp): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFpOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFp | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFp | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFpList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFpOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthClientType {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthClientTypeToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthClientType): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthClientTypeToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthClientType): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthClientTypeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthClientType | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthClientType | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthClientTypeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthClientTypeOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkce {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkceToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkce): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkceToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkce): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkce | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkce | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkceList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkceOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokens {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokensToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokens): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokensToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokens): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokensOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokens | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokens | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokensList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokensOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUri {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthRedirectUriToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUri): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthRedirectUriToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUri): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUriOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUri | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUri | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUriList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUriOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidity {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidityToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidity): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidityToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidity): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidity | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidity | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidityList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidityOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpoint {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpointToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpoint): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpointToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpoint): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpoint | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpoint | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpointList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpointOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRoles {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRolesToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRoles): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRolesToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRoles): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRolesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRoles | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRoles | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRolesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRolesOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStruct {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStructToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStruct): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStructToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStruct): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStructOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStruct | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStruct | undefined);
    get default(): string;
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStructList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStructOutputReference;
}
export interface OauthIntegrationForCustomClientsDescribeOutput {
}
export declare function oauthIntegrationForCustomClientsDescribeOutputToTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutput): any;
export declare function oauthIntegrationForCustomClientsDescribeOutputToHclTerraform(struct?: OauthIntegrationForCustomClientsDescribeOutput): any;
export declare class OauthIntegrationForCustomClientsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsDescribeOutput | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsDescribeOutput | undefined);
    private _blockedRolesList;
    get blockedRolesList(): OauthIntegrationForCustomClientsDescribeOutputBlockedRolesListStructList;
    private _comment;
    get comment(): OauthIntegrationForCustomClientsDescribeOutputCommentList;
    private _enabled;
    get enabled(): OauthIntegrationForCustomClientsDescribeOutputEnabledList;
    private _networkPolicy;
    get networkPolicy(): OauthIntegrationForCustomClientsDescribeOutputNetworkPolicyList;
    private _oauthAllowNonTlsRedirectUri;
    get oauthAllowNonTlsRedirectUri(): OauthIntegrationForCustomClientsDescribeOutputOauthAllowNonTlsRedirectUriList;
    private _oauthAllowedAuthorizationEndpoints;
    get oauthAllowedAuthorizationEndpoints(): OauthIntegrationForCustomClientsDescribeOutputOauthAllowedAuthorizationEndpointsList;
    private _oauthAllowedTokenEndpoints;
    get oauthAllowedTokenEndpoints(): OauthIntegrationForCustomClientsDescribeOutputOauthAllowedTokenEndpointsList;
    private _oauthAuthorizationEndpoint;
    get oauthAuthorizationEndpoint(): OauthIntegrationForCustomClientsDescribeOutputOauthAuthorizationEndpointList;
    private _oauthClientId;
    get oauthClientId(): OauthIntegrationForCustomClientsDescribeOutputOauthClientIdList;
    private _oauthClientRsaPublicKey2Fp;
    get oauthClientRsaPublicKey2Fp(): OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKey2FpList;
    private _oauthClientRsaPublicKeyFp;
    get oauthClientRsaPublicKeyFp(): OauthIntegrationForCustomClientsDescribeOutputOauthClientRsaPublicKeyFpList;
    private _oauthClientType;
    get oauthClientType(): OauthIntegrationForCustomClientsDescribeOutputOauthClientTypeList;
    private _oauthEnforcePkce;
    get oauthEnforcePkce(): OauthIntegrationForCustomClientsDescribeOutputOauthEnforcePkceList;
    private _oauthIssueRefreshTokens;
    get oauthIssueRefreshTokens(): OauthIntegrationForCustomClientsDescribeOutputOauthIssueRefreshTokensList;
    private _oauthRedirectUri;
    get oauthRedirectUri(): OauthIntegrationForCustomClientsDescribeOutputOauthRedirectUriList;
    private _oauthRefreshTokenValidity;
    get oauthRefreshTokenValidity(): OauthIntegrationForCustomClientsDescribeOutputOauthRefreshTokenValidityList;
    private _oauthTokenEndpoint;
    get oauthTokenEndpoint(): OauthIntegrationForCustomClientsDescribeOutputOauthTokenEndpointList;
    private _oauthUseSecondaryRoles;
    get oauthUseSecondaryRoles(): OauthIntegrationForCustomClientsDescribeOutputOauthUseSecondaryRolesList;
    private _preAuthorizedRolesList;
    get preAuthorizedRolesList(): OauthIntegrationForCustomClientsDescribeOutputPreAuthorizedRolesListStructList;
}
export declare class OauthIntegrationForCustomClientsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsDescribeOutputOutputReference;
}
export interface OauthIntegrationForCustomClientsShowOutput {
}
export declare function oauthIntegrationForCustomClientsShowOutputToTerraform(struct?: OauthIntegrationForCustomClientsShowOutput): any;
export declare function oauthIntegrationForCustomClientsShowOutputToHclTerraform(struct?: OauthIntegrationForCustomClientsShowOutput): any;
export declare class OauthIntegrationForCustomClientsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): OauthIntegrationForCustomClientsShowOutput | undefined;
    set internalValue(value: OauthIntegrationForCustomClientsShowOutput | undefined);
    get category(): string;
    get comment(): string;
    get createdOn(): string;
    get enabled(): cdktf.IResolvable;
    get integrationType(): string;
    get name(): string;
}
export declare class OauthIntegrationForCustomClientsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): OauthIntegrationForCustomClientsShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients snowflake_oauth_integration_for_custom_clients}
*/
export declare class OauthIntegrationForCustomClients extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_oauth_integration_for_custom_clients";
    /**
    * Generates CDKTF code for importing a OauthIntegrationForCustomClients resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the OauthIntegrationForCustomClients to import
    * @param importFromId The id of the existing OauthIntegrationForCustomClients that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the OauthIntegrationForCustomClients to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/oauth_integration_for_custom_clients snowflake_oauth_integration_for_custom_clients} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options OauthIntegrationForCustomClientsConfig
    */
    constructor(scope: Construct, id: string, config: OauthIntegrationForCustomClientsConfig);
    private _blockedRolesList?;
    get blockedRolesList(): string[];
    set blockedRolesList(value: string[]);
    get blockedRolesListInput(): string[] | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): OauthIntegrationForCustomClientsDescribeOutputList;
    private _enabled?;
    get enabled(): string;
    set enabled(value: string);
    resetEnabled(): void;
    get enabledInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkPolicy?;
    get networkPolicy(): string;
    set networkPolicy(value: string);
    resetNetworkPolicy(): void;
    get networkPolicyInput(): string | undefined;
    private _oauthAllowNonTlsRedirectUri?;
    get oauthAllowNonTlsRedirectUri(): string;
    set oauthAllowNonTlsRedirectUri(value: string);
    resetOauthAllowNonTlsRedirectUri(): void;
    get oauthAllowNonTlsRedirectUriInput(): string | undefined;
    private _oauthClientRsaPublicKey?;
    get oauthClientRsaPublicKey(): string;
    set oauthClientRsaPublicKey(value: string);
    resetOauthClientRsaPublicKey(): void;
    get oauthClientRsaPublicKeyInput(): string | undefined;
    private _oauthClientRsaPublicKey2?;
    get oauthClientRsaPublicKey2(): string;
    set oauthClientRsaPublicKey2(value: string);
    resetOauthClientRsaPublicKey2(): void;
    get oauthClientRsaPublicKey2Input(): string | undefined;
    private _oauthClientType?;
    get oauthClientType(): string;
    set oauthClientType(value: string);
    get oauthClientTypeInput(): string | undefined;
    private _oauthEnforcePkce?;
    get oauthEnforcePkce(): string;
    set oauthEnforcePkce(value: string);
    resetOauthEnforcePkce(): void;
    get oauthEnforcePkceInput(): string | undefined;
    private _oauthIssueRefreshTokens?;
    get oauthIssueRefreshTokens(): string;
    set oauthIssueRefreshTokens(value: string);
    resetOauthIssueRefreshTokens(): void;
    get oauthIssueRefreshTokensInput(): string | undefined;
    private _oauthRedirectUri?;
    get oauthRedirectUri(): string;
    set oauthRedirectUri(value: string);
    get oauthRedirectUriInput(): string | undefined;
    private _oauthRefreshTokenValidity?;
    get oauthRefreshTokenValidity(): number;
    set oauthRefreshTokenValidity(value: number);
    resetOauthRefreshTokenValidity(): void;
    get oauthRefreshTokenValidityInput(): number | undefined;
    private _oauthUseSecondaryRoles?;
    get oauthUseSecondaryRoles(): string;
    set oauthUseSecondaryRoles(value: string);
    resetOauthUseSecondaryRoles(): void;
    get oauthUseSecondaryRolesInput(): string | undefined;
    private _preAuthorizedRolesList?;
    get preAuthorizedRolesList(): string[];
    set preAuthorizedRolesList(value: string[]);
    resetPreAuthorizedRolesList(): void;
    get preAuthorizedRolesListInput(): string[] | undefined;
    private _showOutput;
    get showOutput(): OauthIntegrationForCustomClientsShowOutputList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
