/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamConfig extends cdktf.TerraformMetaArguments {
    /**
    * Type of the stream that will be created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#append_only Stream#append_only}
    */
    readonly appendOnly?: boolean | cdktf.IResolvable;
    /**
    * Specifies a comment for the stream.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#comment Stream#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the stream.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#database Stream#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#id Stream#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Create an insert only stream type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#insert_only Stream#insert_only}
    */
    readonly insertOnly?: boolean | cdktf.IResolvable;
    /**
    * Specifies the identifier for the stream; must be unique for the database and schema in which the stream is created.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#name Stream#name}
    */
    readonly name: string;
    /**
    * Specifies an identifier for the stage the stream will monitor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#on_stage Stream#on_stage}
    */
    readonly onStage?: string;
    /**
    * Specifies an identifier for the table the stream will monitor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#on_table Stream#on_table}
    */
    readonly onTable?: string;
    /**
    * Specifies an identifier for the view the stream will monitor.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#on_view Stream#on_view}
    */
    readonly onView?: string;
    /**
    * The schema in which to create the stream.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#schema Stream#schema}
    */
    readonly schema: string;
    /**
    * Specifies whether to return all existing rows in the source table as row inserts the first time the stream is consumed.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#show_initial_rows Stream#show_initial_rows}
    */
    readonly showInitialRows?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream snowflake_stream}
*/
export declare class Stream extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_stream";
    /**
    * Generates CDKTF code for importing a Stream resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Stream to import
    * @param importFromId The id of the existing Stream that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Stream to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/stream snowflake_stream} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamConfig
    */
    constructor(scope: Construct, id: string, config: StreamConfig);
    private _appendOnly?;
    get appendOnly(): boolean | cdktf.IResolvable;
    set appendOnly(value: boolean | cdktf.IResolvable);
    resetAppendOnly(): void;
    get appendOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _insertOnly?;
    get insertOnly(): boolean | cdktf.IResolvable;
    set insertOnly(value: boolean | cdktf.IResolvable);
    resetInsertOnly(): void;
    get insertOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _onStage?;
    get onStage(): string;
    set onStage(value: string);
    resetOnStage(): void;
    get onStageInput(): string | undefined;
    private _onTable?;
    get onTable(): string;
    set onTable(value: string);
    resetOnTable(): void;
    get onTableInput(): string | undefined;
    private _onView?;
    get onView(): string;
    set onView(value: string);
    resetOnView(): void;
    get onViewInput(): string | undefined;
    get owner(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showInitialRows?;
    get showInitialRows(): boolean | cdktf.IResolvable;
    set showInitialRows(value: boolean | cdktf.IResolvable);
    resetShowInitialRows(): void;
    get showInitialRowsInput(): boolean | cdktf.IResolvable | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
