/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StreamlitConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies a comment for the streamlit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#comment Streamlit#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the streamlit
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#database Streamlit#database}
    */
    readonly database: string;
    /**
    * Specifies the full path to the named stage containing the Streamlit Python files, media files, and the environment.yml file.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#directory_location Streamlit#directory_location}
    */
    readonly directoryLocation?: string;
    /**
    * External access integrations connected to the Streamlit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#external_access_integrations Streamlit#external_access_integrations}
    */
    readonly externalAccessIntegrations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#id Streamlit#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the filename of the Streamlit Python application. This filename is relative to the value of `root_location`
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#main_file Streamlit#main_file}
    */
    readonly mainFile: string;
    /**
    * String that specifies the identifier (i.e. name) for the streamlit; must be unique in your account.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#name Streamlit#name}
    */
    readonly name: string;
    /**
    * Specifies the warehouse where SQL queries issued by the Streamlit application are run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#query_warehouse Streamlit#query_warehouse}
    */
    readonly queryWarehouse?: string;
    /**
    * The schema in which to create the streamlit.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#schema Streamlit#schema}
    */
    readonly schema: string;
    /**
    * The stage in which streamlit files are located.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#stage Streamlit#stage}
    */
    readonly stage: string;
    /**
    * Specifies a title for the Streamlit app to display in Snowsight.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#title Streamlit#title}
    */
    readonly title?: string;
}
export interface StreamlitDescribeOutput {
}
export declare function streamlitDescribeOutputToTerraform(struct?: StreamlitDescribeOutput): any;
export declare function streamlitDescribeOutputToHclTerraform(struct?: StreamlitDescribeOutput): any;
export declare class StreamlitDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StreamlitDescribeOutput | undefined;
    set internalValue(value: StreamlitDescribeOutput | undefined);
    get defaultPackages(): string;
    get externalAccessIntegrations(): string[];
    get externalAccessSecrets(): string;
    get importUrls(): string[];
    get mainFile(): string;
    get name(): string;
    get queryWarehouse(): string;
    get rootLocation(): string;
    get title(): string;
    get urlId(): string;
    get userPackages(): string[];
}
export declare class StreamlitDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StreamlitDescribeOutputOutputReference;
}
export interface StreamlitShowOutput {
}
export declare function streamlitShowOutputToTerraform(struct?: StreamlitShowOutput): any;
export declare function streamlitShowOutputToHclTerraform(struct?: StreamlitShowOutput): any;
export declare class StreamlitShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StreamlitShowOutput | undefined;
    set internalValue(value: StreamlitShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get queryWarehouse(): string;
    get schemaName(): string;
    get title(): string;
    get urlId(): string;
}
export declare class StreamlitShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StreamlitShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit snowflake_streamlit}
*/
export declare class Streamlit extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_streamlit";
    /**
    * Generates CDKTF code for importing a Streamlit resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Streamlit to import
    * @param importFromId The id of the existing Streamlit that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Streamlit to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/streamlit snowflake_streamlit} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StreamlitConfig
    */
    constructor(scope: Construct, id: string, config: StreamlitConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): StreamlitDescribeOutputList;
    private _directoryLocation?;
    get directoryLocation(): string;
    set directoryLocation(value: string);
    resetDirectoryLocation(): void;
    get directoryLocationInput(): string | undefined;
    private _externalAccessIntegrations?;
    get externalAccessIntegrations(): string[];
    set externalAccessIntegrations(value: string[]);
    resetExternalAccessIntegrations(): void;
    get externalAccessIntegrationsInput(): string[] | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _mainFile?;
    get mainFile(): string;
    set mainFile(value: string);
    get mainFileInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queryWarehouse?;
    get queryWarehouse(): string;
    set queryWarehouse(value: string);
    resetQueryWarehouse(): void;
    get queryWarehouseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): StreamlitShowOutputList;
    private _stage?;
    get stage(): string;
    set stage(value: string);
    get stageInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    resetTitle(): void;
    get titleInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
