/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface TableColumnMaskingPolicyApplicationConfig extends cdktf.TerraformMetaArguments {
    /**
    * The column to apply the masking policy to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/table_column_masking_policy_application#column TableColumnMaskingPolicyApplication#column}
    */
    readonly column: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/table_column_masking_policy_application#id TableColumnMaskingPolicyApplication#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Fully qualified name (`database.schema.policyname`) of the policy to apply.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/table_column_masking_policy_application#masking_policy TableColumnMaskingPolicyApplication#masking_policy}
    */
    readonly maskingPolicy: string;
    /**
    * The fully qualified name (`database.schema.table`) of the table to apply the masking policy to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/table_column_masking_policy_application#table TableColumnMaskingPolicyApplication#table}
    */
    readonly table: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/table_column_masking_policy_application snowflake_table_column_masking_policy_application}
*/
export declare class TableColumnMaskingPolicyApplication extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_table_column_masking_policy_application";
    /**
    * Generates CDKTF code for importing a TableColumnMaskingPolicyApplication resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the TableColumnMaskingPolicyApplication to import
    * @param importFromId The id of the existing TableColumnMaskingPolicyApplication that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/table_column_masking_policy_application#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the TableColumnMaskingPolicyApplication to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflake-labs/snowflake/0.95.0/docs/resources/table_column_masking_policy_application snowflake_table_column_masking_policy_application} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options TableColumnMaskingPolicyApplicationConfig
    */
    constructor(scope: Construct, id: string, config: TableColumnMaskingPolicyApplicationConfig);
    private _column?;
    get column(): string;
    set column(value: string);
    get columnInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maskingPolicy?;
    get maskingPolicy(): string;
    set maskingPolicy(value: string);
    get maskingPolicyInput(): string | undefined;
    private _table?;
    get table(): string;
    set table(value: string);
    get tableInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
