/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AaaaRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The IPv6 addresses this record set will point to.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/aaaa_record_set#addresses AaaaRecordSet#addresses}
    */
    readonly addresses: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/aaaa_record_set#id AaaaRecordSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the record set. The `zone` argument will be appended to this value to create the full record path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/aaaa_record_set#name AaaaRecordSet#name}
    */
    readonly name?: string;
    /**
    * The TTL of the record set. Defaults to `3600`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/aaaa_record_set#ttl AaaaRecordSet#ttl}
    */
    readonly ttl?: number;
    /**
    * DNS zone the record set belongs to. It must be an FQDN, that is, include the trailing dot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/aaaa_record_set#zone AaaaRecordSet#zone}
    */
    readonly zone: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/aaaa_record_set dns_aaaa_record_set}
*/
export declare class AaaaRecordSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "dns_aaaa_record_set";
    /**
    * Generates CDKTF code for importing a AaaaRecordSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the AaaaRecordSet to import
    * @param importFromId The id of the existing AaaaRecordSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/aaaa_record_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the AaaaRecordSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/aaaa_record_set dns_aaaa_record_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AaaaRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: AaaaRecordSetConfig);
    private _addresses?;
    get addresses(): string[];
    set addresses(value: string[]);
    get addressesInput(): string[] | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
