/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDnsARecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Host to look up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/a_record_set#host DataDnsARecordSet#host}
    */
    readonly host: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/a_record_set dns_a_record_set}
*/
export declare class DataDnsARecordSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "dns_a_record_set";
    /**
    * Generates CDKTF code for importing a DataDnsARecordSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataDnsARecordSet to import
    * @param importFromId The id of the existing DataDnsARecordSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/a_record_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataDnsARecordSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/a_record_set dns_a_record_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDnsARecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DataDnsARecordSetConfig);
    get addrs(): string[];
    private _host?;
    get host(): string;
    set host(value: string);
    get hostInput(): string | undefined;
    get id(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
