/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDnsMxRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Domain to look up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/mx_record_set#domain DataDnsMxRecordSet#domain}
    */
    readonly domain: string;
}
export interface DataDnsMxRecordSetMx {
}
export declare function dataDnsMxRecordSetMxToTerraform(struct?: DataDnsMxRecordSetMx): any;
export declare class DataDnsMxRecordSetMxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataDnsMxRecordSetMx | undefined;
    set internalValue(value: DataDnsMxRecordSetMx | undefined);
    get exchange(): string;
    get preference(): number;
}
export declare class DataDnsMxRecordSetMxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataDnsMxRecordSetMxOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/mx_record_set dns_mx_record_set}
*/
export declare class DataDnsMxRecordSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "dns_mx_record_set";
    /**
    * Generates CDKTF code for importing a DataDnsMxRecordSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataDnsMxRecordSet to import
    * @param importFromId The id of the existing DataDnsMxRecordSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/mx_record_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataDnsMxRecordSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/mx_record_set dns_mx_record_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDnsMxRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DataDnsMxRecordSetConfig);
    private _domain?;
    get domain(): string;
    set domain(value: string);
    get domainInput(): string | undefined;
    get id(): string;
    private _mx;
    get mx(): DataDnsMxRecordSetMxList;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
