/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataDnsPtrRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * IP address to look up.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/ptr_record_set#ip_address DataDnsPtrRecordSet#ip_address}
    */
    readonly ipAddress: string;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/ptr_record_set dns_ptr_record_set}
*/
export declare class DataDnsPtrRecordSet extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "dns_ptr_record_set";
    /**
    * Generates CDKTF code for importing a DataDnsPtrRecordSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DataDnsPtrRecordSet to import
    * @param importFromId The id of the existing DataDnsPtrRecordSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/ptr_record_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DataDnsPtrRecordSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/data-sources/ptr_record_set dns_ptr_record_set} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataDnsPtrRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DataDnsPtrRecordSetConfig);
    get id(): string;
    private _ipAddress?;
    get ipAddress(): string;
    set ipAddress(value: string);
    get ipAddressInput(): string | undefined;
    get ptr(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
