/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface MxRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the record set. The `zone` argument will be appended to this value to create the full record path.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set#name MxRecordSet#name}
    */
    readonly name?: string;
    /**
    * The TTL of the record set. Defaults to `3600`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set#ttl MxRecordSet#ttl}
    */
    readonly ttl?: number;
    /**
    * DNS zone the record set belongs to. It must be an FQDN, that is, include the trailing dot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set#zone MxRecordSet#zone}
    */
    readonly zone: string;
    /**
    * mx block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set#mx MxRecordSet#mx}
    */
    readonly mx?: MxRecordSetMx[] | cdktf.IResolvable;
}
export interface MxRecordSetMx {
    /**
    * The FQDN of the mail exchange, include the trailing dot.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set#exchange MxRecordSet#exchange}
    */
    readonly exchange: string;
    /**
    * The preference for the record.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set#preference MxRecordSet#preference}
    */
    readonly preference: number;
}
export declare function mxRecordSetMxToTerraform(struct?: MxRecordSetMx | cdktf.IResolvable): any;
export declare class MxRecordSetMxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): MxRecordSetMx | cdktf.IResolvable | undefined;
    set internalValue(value: MxRecordSetMx | cdktf.IResolvable | undefined);
    private _exchange?;
    get exchange(): string;
    set exchange(value: string);
    get exchangeInput(): string | undefined;
    private _preference?;
    get preference(): number;
    set preference(value: number);
    get preferenceInput(): number | undefined;
}
export declare class MxRecordSetMxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: MxRecordSetMx[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): MxRecordSetMxOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set dns_mx_record_set}
*/
export declare class MxRecordSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "dns_mx_record_set";
    /**
    * Generates CDKTF code for importing a MxRecordSet resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the MxRecordSet to import
    * @param importFromId The id of the existing MxRecordSet that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the MxRecordSet to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs/resources/mx_record_set dns_mx_record_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options MxRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: MxRecordSetConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    get zoneInput(): string | undefined;
    private _mx;
    get mx(): MxRecordSetMxList;
    putMx(value: MxRecordSetMx[] | cdktf.IResolvable): void;
    resetMx(): void;
    get mxInput(): cdktf.IResolvable | MxRecordSetMx[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
