"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DnsProvider = exports.dnsProviderUpdateToTerraform = exports.dnsProviderUpdateGssapiToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function dnsProviderUpdateGssapiToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        keytab: cdktf.stringToTerraform(struct.keytab),
        password: cdktf.stringToTerraform(struct.password),
        realm: cdktf.stringToTerraform(struct.realm),
        username: cdktf.stringToTerraform(struct.username),
    };
}
exports.dnsProviderUpdateGssapiToTerraform = dnsProviderUpdateGssapiToTerraform;
function dnsProviderUpdateToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        key_algorithm: cdktf.stringToTerraform(struct.keyAlgorithm),
        key_name: cdktf.stringToTerraform(struct.keyName),
        key_secret: cdktf.stringToTerraform(struct.keySecret),
        port: cdktf.numberToTerraform(struct.port),
        retries: cdktf.numberToTerraform(struct.retries),
        server: cdktf.stringToTerraform(struct.server),
        timeout: cdktf.stringToTerraform(struct.timeout),
        transport: cdktf.stringToTerraform(struct.transport),
        gssapi: cdktf.listMapper(dnsProviderUpdateGssapiToTerraform, true)(struct.gssapi),
    };
}
exports.dnsProviderUpdateToTerraform = dnsProviderUpdateToTerraform;
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs dns}
*/
class DnsProvider extends cdktf.TerraformProvider {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a DnsProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the DnsProvider to import
    * @param importFromId The id of the existing DnsProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the DnsProvider to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "dns", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/dns/3.3.2/docs dns} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'dns',
            terraformGeneratorMetadata: {
                providerName: 'dns',
                providerVersion: '3.3.2',
                providerVersionConstraint: '~> 3.2'
            },
            terraformProviderSource: 'dns'
        });
        this._alias = config.alias;
        this._update = config.update;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get update() {
        return this._update;
    }
    set update(value) {
        this._update = value;
    }
    resetUpdate() {
        this._update = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get updateInput() {
        return this._update;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            alias: cdktf.stringToTerraform(this._alias),
            update: cdktf.listMapper(dnsProviderUpdateToTerraform, true)(this._update),
        };
    }
}
exports.DnsProvider = DnsProvider;
_a = JSII_RTTI_SYMBOL_1;
DnsProvider[_a] = { fqn: "@cdktf/provider-dns.provider.DnsProvider", version: "7.0.0" };
// =================
// STATIC PROPERTIES
// =================
DnsProvider.tfResourceType = "dns";
//# sourceMappingURL=data:application/json;base64,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