"""Application layer for TelemetryFlow SDK - CQRS commands and queries."""

from telemetryflow.application.commands import (
    AddSpanEventCommand,
    Command,
    CommandBus,
    CommandHandler,
    EmitBatchLogsCommand,
    EmitLogCommand,
    EndSpanCommand,
    FlushTelemetryCommand,
    InitializeSDKCommand,
    RecordCounterCommand,
    RecordGaugeCommand,
    RecordHistogramCommand,
    RecordMetricCommand,
    ShutdownSDKCommand,
    StartSpanCommand,
)
from telemetryflow.application.queries import (
    AggregateMetricsQuery,
    GetHealthQuery,
    GetLogsQuery,
    GetMetricQuery,
    GetSDKStatusQuery,
    GetTraceQuery,
    HealthQueryResult,
    LogsQueryResult,
    MetricQueryResult,
    Query,
    QueryBus,
    QueryHandler,
    SDKStatusResult,
    SearchTracesQuery,
    TraceQueryResult,
)

__all__ = [
    # Commands
    "Command",
    "CommandHandler",
    "CommandBus",
    "InitializeSDKCommand",
    "ShutdownSDKCommand",
    "FlushTelemetryCommand",
    "RecordMetricCommand",
    "RecordCounterCommand",
    "RecordGaugeCommand",
    "RecordHistogramCommand",
    "EmitLogCommand",
    "EmitBatchLogsCommand",
    "StartSpanCommand",
    "EndSpanCommand",
    "AddSpanEventCommand",
    # Queries
    "Query",
    "QueryHandler",
    "QueryBus",
    "GetMetricQuery",
    "AggregateMetricsQuery",
    "GetLogsQuery",
    "GetTraceQuery",
    "SearchTracesQuery",
    "GetHealthQuery",
    "GetSDKStatusQuery",
    # Query Results
    "MetricQueryResult",
    "LogsQueryResult",
    "TraceQueryResult",
    "HealthQueryResult",
    "SDKStatusResult",
]
