"""TelemetryFlow metrics helpers.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-gen.
"""

from __future__ import annotations

from typing import TYPE_CHECKING

if TYPE_CHECKING:
    from typing import Any

from . import get_client


def increment_counter(
    name: str,
    value: int = 1,
    attributes: dict[str, Any] | None = None,
) -> None:
    """Increment a counter metric.

    Args:
        name: Metric name (e.g., "app.requests.total").
        value: Value to increment by (default: 1).
        attributes: Optional metric attributes.

    Example:
        >>> from telemetry.metrics import increment_counter
        >>> increment_counter("api.requests.total", attributes={"endpoint": "/users"})
    """
    client = get_client()
    client.increment_counter(name, value, attributes=attributes)


def record_gauge(
    name: str,
    value: float,
    attributes: dict[str, Any] | None = None,
) -> None:
    """Record a gauge metric value.

    Args:
        name: Metric name (e.g., "app.active_connections").
        value: Current value to record.
        attributes: Optional metric attributes.

    Example:
        >>> from telemetry.metrics import record_gauge
        >>> record_gauge("app.queue_size", 42)
    """
    client = get_client()
    client.record_gauge(name, value, attributes=attributes)


def record_histogram(
    name: str,
    value: float,
    unit: str = "",
    attributes: dict[str, Any] | None = None,
) -> None:
    """Record a histogram value.

    Args:
        name: Metric name (e.g., "app.request.duration").
        value: Value to record.
        unit: Optional unit (e.g., "s", "ms", "bytes").
        attributes: Optional metric attributes.

    Example:
        >>> from telemetry.metrics import record_histogram
        >>> record_histogram("api.latency", 0.125, unit="s")
    """
    client = get_client()
    client.record_histogram(name, value, unit=unit, attributes=attributes)


__all__ = [
    "increment_counter",
    "record_gauge",
    "record_histogram",
]
