# ${project_name} API Documentation

## Overview

This document describes the REST API endpoints for ${project_name}.

**Base URL:** `http://localhost:${server_port}/api/v1`

## Authentication

All API endpoints (except health checks) require JWT authentication.

### Obtaining a Token

```bash
curl -X POST http://localhost:${server_port}/api/v1/auth/login \
  -H "Content-Type: application/json" \
  -d '{"username": "user", "password": "password"}'
```

### Using the Token

Include the JWT token in the Authorization header:

```bash
curl -X GET http://localhost:${server_port}/api/v1/resource \
  -H "Authorization: Bearer <your-token>"
```

## Health Endpoints

### Health Check

Check if the service is healthy.

```
GET /api/v1/health
```

**Response:**

```json
{
  "status": "healthy",
  "service": "${service_name}",
  "version": "${service_version}"
}
```

### Readiness Check

Check if the service is ready to accept traffic.

```
GET /api/v1/ready
```

**Response:**

```json
{
  "status": "ready"
}
```

### Liveness Check

Check if the service is alive.

```
GET /api/v1/live
```

**Response:**

```json
{
  "status": "alive"
}
```

## Response Format

### Success Response

```json
{
  "success": true,
  "data": { ... },
  "message": "Operation completed successfully"
}
```

### Error Response

```json
{
  "success": false,
  "message": "Error description",
  "errors": ["Detailed error 1", "Detailed error 2"]
}
```

### Paginated Response

```json
{
  "success": true,
  "data": [...],
  "total": 100,
  "limit": 20,
  "offset": 0
}
```

## HTTP Status Codes

| Code | Description |
|------|-------------|
| 200 | Success |
| 201 | Created |
| 400 | Bad Request |
| 401 | Unauthorized |
| 403 | Forbidden |
| 404 | Not Found |
| 422 | Validation Error |
| 429 | Too Many Requests |
| 500 | Internal Server Error |

## Rate Limiting

API requests are rate-limited to 100 requests per minute per IP address.

When rate limited, you'll receive a `429 Too Many Requests` response with headers:

- `X-RateLimit-Limit`: Maximum requests per window
- `X-RateLimit-Remaining`: Remaining requests in current window
- `X-RateLimit-Reset`: Unix timestamp when the window resets

## Interactive Documentation

Swagger UI is available at: `http://localhost:${server_port}/apidocs`

---

*Generated by TelemetryFlow RESTful API Generator*
