"""${entity_name} Command Handlers.

TelemetryFlow Python SDK - Community Enterprise Observability Platform (CEOP)
Copyright (c) 2024-2026 DevOpsCorner Indonesia. All rights reserved.

Auto-generated by telemetryflow-restapi.
"""

from __future__ import annotations

from ${module_name}.application.command.${entity_name_lower}_commands import (
    Create${entity_name}Command,
    Update${entity_name}Command,
    Delete${entity_name}Command,
)
from ${module_name}.application.handler.base import CommandHandler
from ${module_name}.domain.entity.${entity_name_lower} import ${entity_name}
from ${module_name}.domain.repository.${entity_name_lower}_repository import ${entity_name}Repository


class Create${entity_name}Handler(CommandHandler[Create${entity_name}Command, ${entity_name}]):
    """Handler for Create${entity_name}Command."""

    def __init__(self, repository: ${entity_name}Repository) -> None:
        self.repository = repository

    def handle(self, command: Create${entity_name}Command) -> ${entity_name}:
        """Handle create ${entity_name_lower} command."""
        entity = ${entity_name}()
        # Map command fields to entity
        return self.repository.save(entity)


class Update${entity_name}Handler(CommandHandler[Update${entity_name}Command, ${entity_name} | None]):
    """Handler for Update${entity_name}Command."""

    def __init__(self, repository: ${entity_name}Repository) -> None:
        self.repository = repository

    def handle(self, command: Update${entity_name}Command) -> ${entity_name} | None:
        """Handle update ${entity_name_lower} command."""
        entity = self.repository.find_by_id(command.id)
        if not entity:
            return None
        # Update entity fields from command
        return self.repository.save(entity)


class Delete${entity_name}Handler(CommandHandler[Delete${entity_name}Command, bool]):
    """Handler for Delete${entity_name}Command."""

    def __init__(self, repository: ${entity_name}Repository) -> None:
        self.repository = repository

    def handle(self, command: Delete${entity_name}Command) -> bool:
        """Handle delete ${entity_name_lower} command."""
        return self.repository.delete(command.id)
